package com.alibaba.druid.sql.dialect.postgresql.ast.expr.tablesource;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGSQLObject;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class PGFunctionTableSource extends SQLExprTableSource implements PGSQLObject {
   private final List<SQLParameter> parameters = new ArrayList();

   public PGFunctionTableSource() {
   }

   public PGFunctionTableSource(SQLExpr expr) {
      this.expr = expr;
   }

   public List<SQLParameter> getParameters() {
      return this.parameters;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit((SQLExprTableSource)this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.parameters);
      }

      visitor.endVisit((SQLExprTableSource)this);
   }

   public PGFunctionTableSource clone() {
      PGFunctionTableSource x = new PGFunctionTableSource();
      x.setAlias(this.alias);

      for(SQLParameter e : this.parameters) {
         SQLParameter e2 = e.clone();
         e2.setParent(x);
         x.getParameters().add(e2);
      }

      if (this.flashback != null) {
         x.setFlashback(this.flashback.clone());
      }

      if (this.hints != null) {
         for(SQLHint e : this.hints) {
            SQLHint e2 = e.clone();
            e2.setParent(x);
            x.getHints().add(e2);
         }
      }

      return x;
   }
}
