package com.alibaba.druid.sql.dialect.postgresql.ast.expr.tablesource;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGSQLObject;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGColumnSimpleDefinitionExpr;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import util.sqlparse.visitor.common.Objects;

public class PGMethodInvokeTableSource extends SQLExprTableSource implements PGSQLObject, PGTableSource {
   protected boolean only;
   protected boolean withOrdinality;
   protected boolean isRowsFrom;
   protected List<SQLExpr> parameters = new ArrayList();
   protected List<PGColumnSimpleDefinitionExpr> defines = new ArrayList();

   public List<PGColumnSimpleDefinitionExpr> getDefines() {
      return this.defines;
   }

   public void setDefines(List<PGColumnSimpleDefinitionExpr> defines) {
      this.defines = defines;
      if (defines != null && defines.size() > 0) {
         for(PGColumnSimpleDefinitionExpr define : defines) {
            define.setParent(this);
         }
      }

   }

   public List<SQLExpr> getParameters() {
      return this.parameters;
   }

   public void setParameters(List<SQLExpr> parameters) {
      this.parameters = parameters;
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public boolean isWithOrdinality() {
      return this.withOrdinality;
   }

   public void setWithOrdinality(boolean withOrdinality) {
      this.withOrdinality = withOrdinality;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         if (!super.equals(o)) {
            return false;
         } else {
            PGMethodInvokeTableSource that = (PGMethodInvokeTableSource)o;
            if (that.only != this.only) {
               return false;
            } else if (that.withOrdinality != this.withOrdinality) {
               return false;
            } else {
               return that.isRowsFrom != this.isRowsFrom ? false : Objects.equals(this.parameters, that.parameters);
            }
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(super.hashCode(), this.parameters);
   }

   public void addColumnAlias(SQLName name) {
      if (this.columns == null) {
         this.columns = new ArrayList();
      }

      this.columns.add(name);
   }

   public void addColumnAlias(PGColumnSimpleDefinitionExpr define) {
      define.setParent(this);
      this.defines.add(define);
   }

   public boolean isRowsFrom() {
      return this.isRowsFrom;
   }

   public void setRowsFrom(boolean rowsFrom) {
      this.isRowsFrom = rowsFrom;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.expr != null) {
            this.expr.accept(visitor);
         }

         if (this.parameters != null && this.parameters.size() > 0) {
            for(SQLExpr parameter : this.parameters) {
               parameter.accept(visitor);
            }
         }

         if (this.sampling != null) {
            this.sampling.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public PGMethodInvokeTableSource clone() {
      PGMethodInvokeTableSource ts = new PGMethodInvokeTableSource();
      this.cloneTo(ts);
      if (this.defines != null && this.defines.size() > 0) {
         for(PGColumnSimpleDefinitionExpr define : this.defines) {
            ts.defines.add(define.clone());
         }
      }

      ts.isRowsFrom = this.isRowsFrom;
      return ts;
   }
}
