package com.alibaba.druid.sql.dialect.spark.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.dialect.spark.ast.SparkSqlExprImpl;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import java.util.ArrayList;
import java.util.List;
import util.sqlparse.visitor.common.Objects;

public class SparkDefProperty extends SparkSqlExprImpl {
   private SQLExpr key;
   private SQLExpr value;

   public SparkDefProperty() {
   }

   public SparkDefProperty(SQLExpr key, SQLExpr value) {
      this.key = key;
      this.value = value;
   }

   public SQLExpr getKey() {
      return this.key;
   }

   public void setKey(SQLExpr key) {
      this.key = key;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      this.value = value;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      children.add(this.key);
      if (this.value != null) {
         children.add(this.value);
      }

      return children;
   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.key);
         this.acceptChild(v, this.value);
      }

      v.endVisit(this);
   }

   public SparkDefProperty clone() {
      SparkDefProperty expr = new SparkDefProperty();
      expr.key = this.key.clone();
      if (this.value == null) {
         expr.value = this.value.clone();
      }

      return expr;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SparkDefProperty that = (SparkDefProperty)o;
         return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(this.key, this.value);
   }
}
