package com.alibaba.druid.sql.dialect.spark.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.dialect.spark.ast.SparkSqlExpr;
import com.alibaba.druid.sql.dialect.spark.ast.SparkSqlExprImpl;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import util.sqlparse.visitor.common.Objects;

public class SparkIntervalExpr extends SQLExprImpl implements SQLLiteralExpr, SparkSqlExpr {
   List<SparkIntervalItem> intervals = new ArrayList();
   SparkIntervalItem to;

   public SparkIntervalExpr clone() {
      SparkIntervalExpr x = new SparkIntervalExpr();

      for(SparkIntervalItem interval : this.intervals) {
         this.intervals.add(interval.clone());
      }

      if (this.to != null) {
         x.to = this.to.clone();
      }

      return x;
   }

   public void addItem(SparkIntervalItem x) {
      x.setParent(this);
      this.intervals.add(x);
   }

   public List<SparkIntervalItem> getIntervals() {
      return this.intervals;
   }

   public void setIntervals(List<SparkIntervalItem> intervals) {
      this.intervals = intervals;
   }

   public SparkIntervalItem getTo() {
      return this.to;
   }

   public void setTo(SparkIntervalItem to) {
      to.setParent(this);
      this.to = to;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      children.addAll(this.intervals);
      if (this.to != null) {
         children.add(this.to);
      }

      return children;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((SparkVisitor)visitor);
   }

   public void accept0(SparkVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.intervals);
         this.acceptChild(visitor, this.to);
      }

      visitor.endVisit(this);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SparkIntervalExpr that = (SparkIntervalExpr)o;
         return Objects.equals(this.intervals, that.intervals) && Objects.equals(this.to, that.to);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(this.intervals, this.to);
   }

   public static class SparkIntervalItem extends SparkSqlExprImpl {
      private SparkIntervalType type;
      private SQLExpr value;

      public SparkIntervalType getType() {
         return this.type;
      }

      public void setType(SparkIntervalType type) {
         this.type = type;
      }

      public SQLExpr getValue() {
         return this.value;
      }

      public void setValue(SQLExpr value) {
         this.value = value;
      }

      public List<SQLObject> getChildren() {
         return Arrays.asList(this.value);
      }

      public void accept0(SparkVisitor v) {
         if (v.visit(this)) {
            this.acceptChild(v, this.value);
         }

         v.endVisit(this);
      }

      public SparkIntervalItem clone() {
         SparkIntervalItem item = new SparkIntervalItem();
         item.type = this.type;
         item.value = this.value.clone();
         return item;
      }

      public boolean equals(Object o) {
         if (this == o) {
            return true;
         } else if (o != null && this.getClass() == o.getClass()) {
            SparkIntervalItem that = (SparkIntervalItem)o;
            return this.type == that.type && Objects.equals(this.value, that.value);
         } else {
            return false;
         }
      }

      public int hashCode() {
         return Objects.hash(this.type, this.value);
      }
   }
}
