package com.alibaba.druid.sql.dialect.spark.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLShowCreateTableStatement;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SparkShowCreateTableStatement extends SQLShowCreateTableStatement implements SparkStatement {
   private SQLExprTableSource table;
   private boolean serde;

   public SparkShowCreateTableStatement() {
      this.dbType = DbType.spark;
   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.table);
      }

      v.endVisit(this);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((SparkVisitor)visitor);
   }

   public SQLExprTableSource getTable() {
      return this.table;
   }

   public void setTable(SQLExprTableSource table) {
      this.table = table;
   }

   public boolean isSerde() {
      return this.serde;
   }

   public void setSerde(boolean serde) {
      this.serde = serde;
   }
}
