package com.alibaba.druid.sql.visitor.functions;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;

public class Reverse implements Function {
   public static final Reverse instance = new Reverse();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      if (x.getArguments().size() != 1) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr param0 = (SQLExpr)x.getArguments().get(0);
         param0.accept(visitor);
         Object param0Value = param0.getAttributes().get("eval.value");
         if (param0Value == null) {
            return SQLEvalVisitor.EVAL_ERROR;
         } else {
            String strValue = param0Value.toString();
            StringBuilder buf = new StringBuilder();

            for(int i = strValue.length() - 1; i >= 0; --i) {
               buf.append(strValue.charAt(i));
            }

            String result = buf.toString();
            return result;
         }
      }
   }
}
