package com.alibaba.druid.wall.spi;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.MSSQLServerExportParameterVisitor;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallVisitor;

public class SQLServerWallProvider extends WallProvider {
   public static final String DEFAULT_CONFIG_DIR = "META-INF/druid/wall/sqlserver";

   public SQLServerWallProvider() {
      this(new WallConfig("META-INF/druid/wall/sqlserver"));
   }

   public SQLServerWallProvider(WallConfig config) {
      super(config, DbType.sqlserver);
   }

   public SQLStatementParser createParser(String sql) {
      return new SQLServerStatementParser(sql, new SQLParserFeature[]{SQLParserFeature.EnableSQLBinaryOpExprGroup});
   }

   public WallVisitor createWallVisitor() {
      return new SQLServerWallVisitor(this);
   }

   public ExportParameterVisitor createExportParameterVisitor() {
      return new MSSQLServerExportParameterVisitor();
   }
}
