package com.palacesun.engine.event;

import com.palacesun.engine.common.CallableStatementInformation;
import com.palacesun.engine.common.ConnectionInformation;
import com.palacesun.engine.common.PreparedStatementInformation;
import com.palacesun.engine.common.ResultSetInformation;
import com.palacesun.engine.common.StatementInformation;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompoundJdbcEventListener extends JdbcEventListener {
   private final List<JdbcEventListener> eventListeners;

   public CompoundJdbcEventListener() {
      this.eventListeners = new ArrayList();
   }

   public CompoundJdbcEventListener(List<JdbcEventListener> eventListeners) {
      this.eventListeners = eventListeners;
   }

   /** @deprecated */
   public void addListender(JdbcEventListener listener) {
      this.addListener(listener);
   }

   public void addListener(JdbcEventListener listener) {
      this.eventListeners.add(listener);
   }

   public List<JdbcEventListener> getEventListeners() {
      return Collections.unmodifiableList(this.eventListeners);
   }

   public void onBeforeGetConnection(ConnectionInformation connectionInformation) throws ClassNotFoundException {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeGetConnection(connectionInformation);
      }

   }

   public void onAfterGetConnection(ConnectionInformation connectionInformation, SQLException e) throws SQLException {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterGetConnection(connectionInformation, e);
      }

   }

   /** @deprecated */
   @Deprecated
   public void onConnectionWrapped(ConnectionInformation connectionInformation) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onConnectionWrapped(connectionInformation);
      }

   }

   public void onBeforeAddBatch(PreparedStatementInformation statementInformation) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeAddBatch(statementInformation);
      }

   }

   public void onAfterAddBatch(PreparedStatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterAddBatch(statementInformation, timeElapsedNanos, e);
      }

   }

   public void onBeforeAddBatch(StatementInformation statementInformation, String sql) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeAddBatch(statementInformation, sql);
      }

   }

   public void onAfterAddBatch(StatementInformation statementInformation, long timeElapsedNanos, String sql, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterAddBatch(statementInformation, timeElapsedNanos, sql, e);
      }

   }

   public void onBeforeExecute(PreparedStatementInformation statementInformation) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeExecute(statementInformation);
      }

   }

   public void onAfterExecute(PreparedStatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterExecute(statementInformation, timeElapsedNanos, e);
      }

   }

   public void onBeforeExecute(StatementInformation statementInformation, String sql) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeExecute(statementInformation, sql);
      }

   }

   public void onAfterExecute(StatementInformation statementInformation, long timeElapsedNanos, String sql, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterExecute(statementInformation, timeElapsedNanos, sql, e);
      }

   }

   public void onBeforeExecuteBatch(StatementInformation statementInformation) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeExecuteBatch(statementInformation);
      }

   }

   public void onAfterExecuteBatch(StatementInformation statementInformation, long timeElapsedNanos, int[] updateCounts, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterExecuteBatch(statementInformation, timeElapsedNanos, updateCounts, e);
      }

   }

   public void onBeforeExecuteUpdate(PreparedStatementInformation statementInformation) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeExecuteUpdate(statementInformation);
      }

   }

   public void onAfterExecuteUpdate(PreparedStatementInformation statementInformation, long timeElapsedNanos, int rowCount, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterExecuteUpdate(statementInformation, timeElapsedNanos, rowCount, e);
      }

   }

   public void onBeforeExecuteUpdate(StatementInformation statementInformation, String sql) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeExecuteUpdate(statementInformation, sql);
      }

   }

   public void onAfterExecuteUpdate(StatementInformation statementInformation, long timeElapsedNanos, String sql, int rowCount, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterExecuteUpdate(statementInformation, timeElapsedNanos, sql, rowCount, e);
      }

   }

   public void onBeforeExecuteQuery(PreparedStatementInformation statementInformation) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeExecuteQuery(statementInformation);
      }

   }

   public void onAfterExecuteQuery(PreparedStatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterExecuteQuery(statementInformation, timeElapsedNanos, e);
      }

   }

   public void onBeforeExecuteQuery(StatementInformation statementInformation, String sql) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeExecuteQuery(statementInformation, sql);
      }

   }

   public void onAfterExecuteQuery(StatementInformation statementInformation, long timeElapsedNanos, String sql, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterExecuteQuery(statementInformation, timeElapsedNanos, sql, e);
      }

   }

   public void onAfterPreparedStatementSet(PreparedStatementInformation statementInformation, int parameterIndex, Object value, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterPreparedStatementSet(statementInformation, parameterIndex, value, e);
      }

   }

   public void onAfterCallableStatementSet(CallableStatementInformation statementInformation, String parameterName, Object value, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterCallableStatementSet(statementInformation, parameterName, value, e);
      }

   }

   public void onAfterGetResultSet(StatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterGetResultSet(statementInformation, timeElapsedNanos, e);
      }

   }

   public void onBeforeResultSetNext(ResultSetInformation resultSetInformation) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeResultSetNext(resultSetInformation);
      }

   }

   public void onAfterResultSetNext(ResultSetInformation resultSetInformation, long timeElapsedNanos, boolean hasNext, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterResultSetNext(resultSetInformation, timeElapsedNanos, hasNext, e);
      }

   }

   public void onAfterResultSetClose(ResultSetInformation resultSetInformation, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterResultSetClose(resultSetInformation, e);
      }

   }

   public Object onAfterResultSetGet(ResultSetInformation resultSetInformation, String columnLabel, Object value, SQLException e) throws SQLException {
      for(JdbcEventListener eventListener : this.eventListeners) {
         try {
            value = eventListener.onAfterResultSetGet(resultSetInformation, columnLabel, value, e);
         } catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(e);
         }
      }

      return value;
   }

   public Object onAfterResultSetGet(ResultSetInformation resultSetInformation, int columnIndex, Object value, SQLException e) throws SQLException {
      for(JdbcEventListener eventListener : this.eventListeners) {
         try {
            value = eventListener.onAfterResultSetGet(resultSetInformation, columnIndex, value, e);
         } catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
         }
      }

      return value;
   }

   public void onBeforeCommit(ConnectionInformation connectionInformation) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeCommit(connectionInformation);
      }

   }

   public void onAfterCommit(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterCommit(connectionInformation, timeElapsedNanos, e);
      }

   }

   public void onAfterConnectionClose(ConnectionInformation connectionInformation, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterConnectionClose(connectionInformation, e);
      }

   }

   public void onBeforeRollback(ConnectionInformation connectionInformation) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeRollback(connectionInformation);
      }

   }

   public void onAfterRollback(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterRollback(connectionInformation, timeElapsedNanos, e);
      }

   }

   public void onAfterStatementClose(StatementInformation statementInformation, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterStatementClose(statementInformation, e);
      }

   }

   public void onBeforeSetAutoCommit(ConnectionInformation connectionInformation, boolean newAutoCommit, boolean currentAutoCommit) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeSetAutoCommit(connectionInformation, newAutoCommit, currentAutoCommit);
      }

   }

   public void onAfterSetAutoCommit(ConnectionInformation connectionInformation, boolean newAutoCommit, boolean oldAutoCommit, SQLException e) {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onAfterSetAutoCommit(connectionInformation, newAutoCommit, oldAutoCommit, e);
      }

   }

   public void onBeforeGetResltSetDate(ResultSet resultSet) throws SQLException {
      for(JdbcEventListener eventListener : this.eventListeners) {
         eventListener.onBeforeGetResltSetDate(resultSet);
      }

   }
}
