package com.palacesun.masking.adapter;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesLoaderUtils {
   public static Properties a;

   public static Properties loadAllProperties(String resource) throws IOException {
      if (a != null) {
         return a;
      } else {
         new PropertiesLoaderUtils();
         InputStream in = getResourceAsStream(resource);
         a = new Properties();
         a.load(in);
         a.getProperty("root.port");
         return a;
      }
   }

   public static InputStream getResourceAsStream(String resource) throws FileNotFoundException {
      InputStream in = PropertiesLoaderUtils.class.getResourceAsStream(resource);
      if (in == null) {
         in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
         if (in == null) {
            in = new FileInputStream(resource);
         }
      }

      return in;
   }

   public static void main(String[] args) throws IOException {
      Properties properties = loadAllProperties("/gatewayconfig/config.properties");
      System.out.println(properties);
   }
}
