package com.palacesun.masking.log.access;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CommonSqlBuffer extends SqlBuffer {
   public CommonSqlBuffer(String sql) {
      super(sql);
   }

   protected String getValue(SqlValue value, Object val) {
      if (val == null) {
         return null;
      } else {
         this.setPrimitiveType(value);
         if (value.primiteType == 0) {
            return "null";
         } else if (value.primiteType >= 1 && value.primiteType <= 8) {
            return val.toString();
         } else if (value.primiteType == 9) {
            return "'" + val.toString().replace("'", "''") + "'";
         } else if (value.primiteType == 11) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return val.getClass().equals(Date.class) ? sdf.format((Date)val) : sdf.format((java.sql.Date)val);
         } else if (value.primiteType == 12) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            return sdf.format((Time)val);
         } else if (value.primiteType == 13) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format((Timestamp)val);
         } else if (value.primiteType == 14) {
            InputStream stream = (InputStream)val;
            byte[] values = this.readValue(stream, value.length, value.longLength);
            if (value.targetType != null) {
               if (value.targetType.equals("byte[]")) {
                  return new String(values);
               } else if (value.targetType.equals("byte[ascii]")) {
                  return new String(values);
               } else {
                  return value.targetType.equals("byte[string]") ? new String(values, this.charset) : new String(values);
               }
            } else {
               return new String(values);
            }
         } else if (value.primiteType == 15) {
            return this.emptyValue;
         } else if (value.primiteType == 16) {
            return this.emptyValue;
         } else if (value.primiteType == 17) {
            return val.toString();
         } else if (value.primiteType == 18) {
            return "[blob]";
         } else {
            return value.primiteType >= 19 && value.primiteType <= 24 ? val.toString() : this.emptyValue;
         }
      }
   }

   private void setPrimitiveType(SqlValue val) {
      if (val.primiteType == -1 && val.value != null) {
         Object value = val.value;
         if (value.getClass().equals(Boolean.class)) {
            val.primiteType = 1;
         } else if (value.getClass().equals(Byte.class)) {
            val.primiteType = 2;
         } else if (value.getClass().equals(Long.class)) {
            val.primiteType = 3;
         } else if (value.getClass().equals(Integer.class)) {
            val.primiteType = 4;
         } else if (value.getClass().equals(Float.class)) {
            val.primiteType = 5;
         } else if (value.getClass().equals(Double.class)) {
            val.primiteType = 6;
         } else if (value.getClass().equals(Short.class)) {
            val.primiteType = 7;
         } else if (value.getClass().equals(BigDecimal.class)) {
            val.primiteType = 8;
         } else if (value.getClass().equals(String.class)) {
            val.primiteType = 9;
         } else if (value.getClass().equals(Byte[].class)) {
            val.primiteType = 10;
         } else if (value.getClass().equals(Time.class)) {
            val.primiteType = 12;
         } else if (value.getClass().equals(Timestamp.class)) {
            val.primiteType = 13;
         } else if (value instanceof Date) {
            val.primiteType = 11;
         } else if (value instanceof InputStream) {
            val.primiteType = 14;
         } else if (value instanceof Reader) {
            val.primiteType = 15;
         } else if (value instanceof Ref) {
            val.primiteType = 16;
         } else if (value instanceof RowId) {
            val.primiteType = 17;
         } else if (value instanceof NClob) {
            val.primiteType = 22;
         } else if (value instanceof Blob) {
            val.primiteType = 18;
         } else if (value instanceof Clob) {
            val.primiteType = 19;
         } else if (value instanceof Array) {
            val.primiteType = 20;
         } else if (value instanceof URL) {
            val.primiteType = 21;
         } else if (value instanceof SQLXML) {
            val.primiteType = 23;
         } else {
            val.primiteType = 24;
         }

      }
   }

   private byte[] readValue(InputStream stream, Integer len, Long lLen) {
      ByteArrayOutputStream baos = null;

      byte[] b;
      try {
         baos = new ByteArrayOutputStream();
         if (stream.markSupported()) {
            int l = stream.available();
            if (len != null) {
               l = len;
            } else if (lLen != null) {
               l = (int)lLen.intValue();
            }

            stream.mark(l);
            int b2 = -1;

            while((b2 = stream.read()) != -1) {
               baos.write(b2);
            }

            baos.flush();
         }

         if (len != null) {
            stream.mark(len);
         }

         byte[] var24 = baos.toByteArray();
         return var24;
      } catch (IOException var22) {
         try {
            baos.flush();
         } catch (IOException ioException) {
            ioException.printStackTrace();
         }

         b = baos.toByteArray();
      } finally {
         if (baos != null) {
            try {
               baos.close();
            } catch (IOException e) {
               e.printStackTrace();
            }

            try {
               stream.reset();
            } catch (IOException e) {
               e.printStackTrace();
            }
         }

      }

      return b;
   }
}
