package com.palacesun.masking.tools;

import com.palacesun.masking.adapter.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
   public static String getRequestIp(HttpServletRequest request) {
      String ipAddress = request.getHeader("x-forwarded-for");
      if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
         ipAddress = request.getHeader("Proxy-Client-IP");
      }

      if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
         ipAddress = request.getHeader("WL-Proxy-Client-IP");
      }

      if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
         ipAddress = request.getRemoteAddr();
         if (ipAddress.equals("127.0.0.1") || ipAddress.equals("0:0:0:0:0:0:0:1")) {
            InetAddress inetAddress = null;

            try {
               inetAddress = InetAddress.getLocalHost();
            } catch (UnknownHostException e) {
               e.printStackTrace();
            }

            ipAddress = inetAddress.getHostAddress();
         }
      }

      if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
         ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
      }

      return ipAddress;
   }

   public static boolean ipIsValid(String ipStart, String ipEnd, String ip) {
      if (StringUtils.isEmpty(ipStart)) {
         throw new NullPointerException("起始IP不能为空！");
      } else if (StringUtils.isEmpty(ipEnd)) {
         throw new NullPointerException("结束IP不能为空！");
      } else if (StringUtils.isEmpty(ip)) {
         throw new NullPointerException("IP不能为空！");
      } else {
         ipStart = ipStart.trim();
         ipEnd = ipEnd.trim();
         ip = ip.trim();
         String REGX_IP = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)";
         String REGX_IPB = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\-((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)";
         if (ipStart.matches("((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)") && ip.matches("((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)") && ipEnd.matches("((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)")) {
            String[] sips = ipStart.split("\\.");
            String[] sipe = ipEnd.split("\\.");
            String[] sipt = ip.split("\\.");
            long ips = 0L;
            long ipe = 0L;
            long ipt = 0L;

            for(int i = 0; i < 4; ++i) {
               ips = ips << 8 | (long)Integer.parseInt(sips[i]);
               ipe = ipe << 8 | (long)Integer.parseInt(sipe[i]);
               ipt = ipt << 8 | (long)Integer.parseInt(sipt[i]);
            }

            if (ips > ipe) {
               long t = ips;
               ips = ipe;
               ipe = t;
            }

            return ips <= ipt && ipt <= ipe;
         } else {
            return false;
         }
      }
   }
}
