package util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;

public class HBaseUtil {
   public static Connection getConnection(String ip, String port) {
      Connection connection = null;
      Configuration config = HBaseConfiguration.create();
      config.set("hbase.zookeeper.quorum", ip);
      config.set("hbase.zookeeper.property.clientPort", port);

      try {
         connection = ConnectionFactory.createConnection(config);
      } catch (IOException e) {
         e.printStackTrace();
      }

      return connection;
   }

   public static void closeConnection(Connection connection) {
      if (connection != null) {
         try {
            connection.close();
         } catch (IOException e) {
            e.printStackTrace();
         }
      }

   }

   static {
      System.setProperty("hadoop.home.dir", "E:\\hadooponwindows-master");
   }
}
