package util.sqlparse.visitor.db2.visitor;

import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.db2.ast.expr.tablesource.DB2ExprTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.expr.tablesource.DB2SubqueryTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2DeleteStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2GrantStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2InsertStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2UpdateStatement;
import com.alibaba.druid.sql.dialect.db2.visitor.DefaultDB2ASTVisitor;
import java.util.List;
import util.sqlparse.visitor.common.scope.Scope;

public abstract class ParseVisitor extends DefaultDB2ASTVisitor {
   private boolean debug = false;
   protected Scope scope;

   public ParseVisitor(Scope scope) {
      this.scope = scope;
   }

   public void perform(List<SQLStatement> statements) {
      if (statements != null && statements.size() != 0) {
         for(SQLStatement statement : statements) {
            statement.accept(this);
         }

         this.scope.reset();
      }
   }

   public boolean visit(SQLSelectStatement x) {
      if (this.debug) {
         System.out.println("enter SQLSelectStatement" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLSelectStatement x) {
      if (this.debug) {
         System.out.println("exit SQLSelectStatement" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLInsertStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLInsertStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(DB2InsertStatement x) {
      return this.visit((SQLInsertStatement)x);
   }

   public void endVisit(DB2InsertStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLUpdateStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLUpdateStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(DB2UpdateStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(DB2UpdateStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLDeleteStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLDeleteStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(DB2DeleteStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(DB2DeleteStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(DB2GrantStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(DB2GrantStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLRevokeStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLRevokeStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLWithSubqueryClause x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLWithSubqueryClause x) {
      if (this.debug) {
         System.out.println("exit SQLWithSubqueryClause" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLWithSubqueryClause.Entry x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause.Entry" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLWithSubqueryClause.Entry x) {
      if (this.debug) {
         System.out.println("exit SQLWithSubqueryClause.Entry" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(DB2SelectQueryBlock x) {
      if (this.debug) {
         System.out.println("enter DB2SelectQueryBlock " + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(DB2SelectQueryBlock x) {
      if (this.debug) {
         System.out.println("exit DB2SelectQueryBlock " + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLUnionQuery x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLUnionQuery x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLLateralViewTableSource x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLLateralViewTableSource x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("enter SQLSubqueryTableSource" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("exit SQLSubqueryTableSource" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(DB2SubqueryTableSource x) {
      if (this.debug) {
         System.out.println("enter DB2SubqueryTableSource" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(DB2SubqueryTableSource x) {
      if (this.debug) {
         System.out.println("exit DB2SubqueryTableSource" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLJoinTableSource x) {
      return true;
   }

   public boolean visit(SQLUnionQueryTableSource x) {
      if (this.debug) {
         System.out.println("enter SQLUnionQueryTableSource" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLUnionQueryTableSource x) {
      if (this.debug) {
         System.out.println("exit SQLUnionQueryTableSource" + x.toString());
      }

      this.scope.exitScope();
   }

   public void endVisit(SQLJoinTableSource x) {
   }

   public boolean visit(SQLExprTableSource x) {
      return true;
   }

   public void endVisit(SQLExprTableSource x) {
   }

   public boolean visit(DB2ExprTableSource x) {
      if (!(x.getExpr() instanceof SQLIdentifierExpr)) {
         if (this.debug) {
            System.out.println("enter DB2ExprTableSource  " + x);
         }

         this.scope.enterScope((SQLObject)x);
      } else if (this.debug) {
         System.out.println("begin DB2ExprTableSource" + x.toString());
      }

      return true;
   }

   public void endVisit(DB2ExprTableSource x) {
      if (!(x.getExpr() instanceof SQLIdentifierExpr)) {
         if (this.debug) {
            System.out.println("exit DB2ExprTableSource  " + x);
         }

         this.scope.exitScope();
      } else if (this.debug) {
         System.out.println("end DB2ExprTableSource" + x.toString());
      }

   }

   protected void acceptChild(List<? extends SQLObject> children) {
      if (children != null && children.size() != 0) {
         for(SQLObject child : children) {
            child.accept(this);
         }

      }
   }

   protected void visitChild(SQLObject x) {
      if (x != null) {
         x.accept(this);
      }
   }

   protected void visitChild(List<? extends SQLObject> x) {
      if (x != null && x.size() != 0) {
         for(SQLObject sqlObject : x) {
            this.visitChild(sqlObject);
         }

      }
   }

   protected boolean isEqual(String name1, String name2) {
      return this.scope.dialector.isEqual(name1, name2);
   }
}
