package util.sqlparse.visitor.hivetdh;

import dm.jdbc.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import util.JdbcUtil;
import util.SqlUtil;

public class HiveDesensitizationTest {
   public static void main(String[] args) throws Exception {
      parseTest("SELECT user_id, dept_id, login_name, user_name, user_type, email, phonenumber, sex, avatar, password, salt, status, del_flag, login_ip, login_date, pwd_update_date, create_by, create_time, update_by, update_time, remark, email_copy, remark_copy, login_ip_copy, phonenumber_copy, user_name_copy \nFROM rouyi.sys_user;");
   }

   public static void desensitizationTest(String sql) throws Exception {
      cache();
      desensitization(sql);
   }

   public static void parseTest(String sql) throws Exception {
      cache();
      Map<String, String> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "hive_tdh");
      params.put("schema", "default");
      params.put("url", "jdbc:hive2://10.11.120.15:10000/default");
      SqlUtil sqlUtil = new SqlUtil();
      Map<String, Object> stringObjectMap = sqlUtil.parseSqlStructureAnd(params);
      System.out.println(stringObjectMap);
   }

   private static void cache() {
      String content = "{\n      \"ip_port\": \"10.11.120.15:10000\",\n      \"url\": \"jdbc:hive2://10.11.120.15:10000/default\",\n      \"username\": \"admin\",\n      \"password\": \"admin\",\n      \"dbType\": \"hive_tdh\",\n      \"clickhouseJdbcUrl\": \"jdbc:clickhouse://10.11.130.22:8123/zero_trust\",\n      \"clickhousePassword\": \"ghca_2023\",\n      \"isIgnorecase\": \"0\",\n      \"redisMode\": \"none\",\n      \"redisIp\": \"192.168.2.105\",\n      \"redisNodes\": \"192.168.2.81:6379,192.168.2.81:6380,192.168.2.82:6379,192.168.2.82:6380,192.168.2.83:6379,192.168.2.83:6380\",\n      \"redisPort\": \"6379\",\n      \"redisUsername\": \"\",\n      \"redisPassword\": \"123456\",\n      \"redisDatabase\": \"0\",\n      \"excludeSchema\": [],\n      \"includeSchema\": [\"default\",\"testdb\",\"rouyi\"]\n    }";
      JdbcUtil.initData(content);

      try {
         Thread.sleep(2000L);
      } catch (InterruptedException e) {
         e.printStackTrace();
      }

   }

   private static void desensitization(String sql) throws Exception {
      Map<String, Object> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "hive_tdh");
      params.put("schema", "default");
      params.put("url", "jdbc:hive2://10.11.120.15:10000/default");
      params.put("sql", sql);
      params.put("replaceSchema", ".*");
      params.put("replaceTable", ".*");
      params.put("replaceColumn", ".*test.*");
      params.put("expression", "CONCAT(SUBSTR(${value},0,1) ,'*',SUBSTR(${value},LENGTH (${value})))");
      params.put("$direction", "downflow");
      params.put("maskFieldIds", new HashSet());
      ByteArrayOutputStream out = new ByteArrayOutputStream();
      TCLIService.FetchResults_result result = getFetchResult(out);
      TCLIService.GetResultSetMetadata_result metaData = getMeta(out);
      params.put("FetchResults_result", result);
      params.put("GetResultSetMetadata_result", metaData);
      SqlUtil sqlUtil = new SqlUtil();
      sqlUtil.desensitization(params);
      System.out.println(params);
   }

   private static TCLIService.FetchResults_result getFetchResult(ByteArrayOutputStream out) throws TException {
      String bytes = "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";
      ByteArrayInputStream in = new ByteArrayInputStream(StringUtil.hexStringToBytes(bytes));
      TIOStreamTransport transport = new TIOStreamTransport(in, out);
      TBinaryProtocol protocol = new TBinaryProtocol(transport);
      TCLIService.FetchResults_result result = new TCLIService.FetchResults_result();
      result.read(protocol);
      return result;
   }

   private static TCLIService.GetResultSetMetadata_result getMeta(ByteArrayOutputStream out) throws TException {
      String bytes = "0c00000c000108000100000000000c00020f00010c000000070b0001000000046e616d650c00020f00010c000000010c00010800010000000700000008000300000001000b0001000000036167650c00020f00010c000000010c00010800010000000300000008000300000002000b000100000004646174650c00020f00010c000000010c00010800010000001100000008000300000003000b00010000000574657374310c00020f00010c000000010c0001080001000000180c00020d00010b0c00000001000000166368617261637465724d6178696d756d4c656e67746808000100000064000000000008000300000004000b00010000000574657374320c00020f00010c000000010c0001080001000000140c00020d00010b0c00000001000000166368617261637465724d6178696d756d4c656e67746808000100000064000000000008000300000005000b000100000007636f6c756d6e310c00020f00010c000000010c00010800010000000600000008000300000006000b00010000000863686172746573740c00020f00010c000000010c0001080001000000150c00020d00010b0c00000001000000166368617261637465724d6178696d756d4c656e6774680800010000006400000000000800030000000700000000";
      ByteArrayInputStream in = new ByteArrayInputStream(StringUtil.hexStringToBytes(bytes));
      TIOStreamTransport transport = new TIOStreamTransport(in, out);
      TBinaryProtocol protocol = new TBinaryProtocol(transport);
      TCLIService.GetResultSetMetadata_result metaData = new TCLIService.GetResultSetMetadata_result();
      metaData.read(protocol);
      return metaData;
   }

   private static Map<String, Object> tableReplace(String sql) throws Exception {
      Map<String, String> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "hive_tdh");
      params.put("schema", "default");
      params.put("url", "jdbc:hive2://10.11.120.15:10000/default");
      params.put("sql", sql);
      params.put("replaceSchema", ".*");
      params.put("replaceNewTable", "people_bk");
      params.put("replaceTable", ".*");
      params.put("replaceColumn", ".*");
      params.put("expression", "concat(substr(${value},1,1),'**')");
      params.put("configPath", "D:/masking-mysql.properties");
      params.put("limit", "3");
      SqlUtil sqlUtil = new SqlUtil();
      Map<String, Object> stringObjectMap = sqlUtil.parseSqlStructureAnd(params);
      System.out.println(stringObjectMap);
      System.out.println("..............table_desensitization.....................................");
      String sql3 = sqlUtil.table_desensitization(new HashMap(params));
      System.out.println(sql3);
      return stringObjectMap;
   }
}
