package util.sqlparse.visitor.mariadb.visitor;

import bean.DataBase;
import java.util.List;
import util.sqlparse.visitor.common.ScopeDialector;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;

public class MySQLScopeDialector extends ScopeDialector {
   public MySQLScopeDialector() {
   }

   public MySQLScopeDialector(Scope scope) {
      super(scope);
   }

   public String wrap(String text) {
      if (text == null) {
         return null;
      } else if (text.contains("`")) {
         return text;
      } else {
         return this.scope.context.getDataBase() != null && this.scope.context.getDataBase().isCaseSensitive() ? text : text;
      }
   }

   public String wrapAlias(String text) {
      if (text == null) {
         return null;
      } else if (text.contains("`")) {
         return text;
      } else {
         return this.scope.context.getDataBase() != null && this.scope.context.getDataBase().isCaseSensitive() ? text : "`" + text + "`";
      }
   }

   public boolean expandAllColumns(TableMemo table, boolean isSub, List<FieldMemo> fields) {
      return true;
   }

   public ScopeDialector clone(Scope scope) {
      return new MySQLScopeDialector(scope);
   }

   public boolean isEqual(String name1, String name2) {
      if (name1 == null && name2 != null) {
         return false;
      } else if (name1 != null && name2 == null) {
         return false;
      } else if (name1 == null && name2 == null) {
         return true;
      } else {
         String placeholder = "`";
         if (!name1.startsWith(placeholder)) {
            name1 = placeholder + name1 + placeholder;
         }

         if (!name2.startsWith(placeholder)) {
            name2 = placeholder + name2 + placeholder;
         }

         DataBase dataBase = this.scope.context.getDataBase();
         return dataBase.isCaseSensitive() ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
      }
   }

   public boolean isColumnEqual(String name1, String name2) {
      if (name1 == null && name2 != null) {
         return false;
      } else if (name1 != null && name2 == null) {
         return false;
      } else {
         return name1 == null && name2 == null ? true : name1.equalsIgnoreCase(name2);
      }
   }
}
