package util.sqlparse.visitor.oracle.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.JdbcUtil;
import util.SqlUtil;

public class DesensitizationTest {
   public static void main(String[] args) throws Exception {
      oracleDesensitization();
   }

   static void oracleDesensitization() throws Exception {
      String sql = "";
      sql = "merge into sys_user_online a\n\t\tusing (select count(1) co\n\t\t         from sys_user_online\n\t\t        where sessionid = ?) b\n\t\ton (b.co   <>   0)\n\t\twhen matched then\n\t\t  update\n\t\t     set login_name       = ?,\n\t\t         dept_name        = ?,\n\t\t         ipaddr           = ?,\n\t\t         login_location   = ?,\n\t\t         browser          = ?,\n\t\t         os               = ?,\n\t\t         status           = ?, \n\t\t         start_timestamp  = ?,\n\t\t         last_access_time = ?,\n\t\t         expire_time      = ?\n\t\t         where sessionid = ?\n\t\twhen not matched then\n\t\t  insert\n\t\t  values\n\t\t    (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) -- appUsername=";
      Map<String, Object> stringObjectMap = oracleParseTest(sql);
      Map<String, Object> params = new HashMap();
      params.put("sql", (String)stringObjectMap.get("sql"));
      params.put("dbType", "oracle");
      params.put("schema", "RY");
      params.put("url", "jdbc:oracle:thin:@192.168.2.103:1521:TEST");
      params.put("replaceSchema", "TEST2");
      params.put("replaceTable", "JOBS");
      params.put("replaceColumn", ".*JOB_ID.*");
      params.put("expression", "concat(left(${value},1), '**') ");
      SqlUtil sqlUtil = new SqlUtil();
      String newsql = sqlUtil.desensitization(params);
      System.out.println(newsql);
   }

   static void oracleFieldReplace() throws Exception {
      String sql = "";
      sql = "SELECT \"JOB_ID\", JOB_TITLE, MIN_SALARY, MAX_SALARY FROM \"TEST2\".\"JOBS\";";
      Map<String, Object> stringObjectMap = oracleParseTest(sql);
      Map<String, Object> params = new HashMap();
      params.put("sql", (String)stringObjectMap.get("sql"));
      params.put("dbType", "oracle");
      params.put("schema", "TEST2");
      params.put("url", "jdbc:oracle:thin:@127.0.0.1:1521:ORCL");
      String filedfullname = "TEST2.JOBS.JOB_ID";
      String[] split = filedfullname.split("\\.");
      params.put("replaceSchema", split[0]);
      params.put("replaceTable", split[1]);
      params.put("replaceColumn", split[2]);
      params.put("expression", "concat(left(${value},1), '**') ");
      SqlUtil sqlUtil = new SqlUtil();
      String newsql = sqlUtil.column_desensitization(params);
      System.out.println(newsql);
   }

   static void oracleTableReplace() throws Exception {
      String sqls = "";
      sqls = "SELECT \"JOB_ID\", JOB_TITLE, MIN_SALARY, MAX_SALARY FROM \"TEST2\".\"JoBS\";";
      Map<String, Object> stringObjectMap = oracleParseTest(sqls);
      String sql = (String)stringObjectMap.get("sql");
      Map<String, String> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "oracle");
      params.put("schema", "TEST2");
      params.put("url", "jdbc:oracle:thin:@127.0.0.1:1521:ORCL");
      params.put("replaceNewTable", "JOBS2");
      params.put("replaceTable", "JOBS");
      SqlUtil sqlUtil = new SqlUtil();
      String newSql = sqlUtil.table_desensitization(params);
      System.out.println(newSql);
      System.out.println("---------------------------");
   }

   static void oracleParseRowVisitTest8() throws Exception {
      String sqls = "";
      sqls = "SELECT * FROM TEST2.\"JoBS\"";
      Map<String, Object> stringObjectMap = oracleParseTest(sqls);
      String tableName = "JOBS";
      String columnName = "\"JOB_ID\"";
      String columnData = "若依1";
      Map<String, List<String>> modifyTable = new HashMap();
      List<String> valueList = new ArrayList();
      valueList.add(columnData);
      modifyTable.put(tableName, valueList);
      Map<String, String> tableKeyWord = new HashMap();
      tableKeyWord.put(tableName, columnName);
      String dbType = "oracle";
      String sql = (String)stringObjectMap.get("sql");
      String operateType = "select";
      Map<String, Object> param = new HashMap();
      param.put("sql", sql);
      param.put("url", "jdbc:oracle:thin:@127.0.0.1:1521:ORCL");
      param.put("schema", "TEST2");
      param.put("modifyTable", modifyTable);
      param.put("tableKeyWord", tableKeyWord);
      param.put("operateType", operateType);
      param.put("dbType", dbType);
      SqlUtil util = new SqlUtil();
      String newSQL = util.rowVisitControl(param);
      System.out.println(newSQL);
      System.out.println("---------------------------");
   }

   static Map<String, Object> oracleParseTest(String sql) throws Exception {
      String content = "{\n      \"ip_port\": \"192.168.2.103:1521\",\n      \"url\": \"jdbc:oracle:thin:@192.168.2.103:1521:TEST\",\n      \"username\": \"RY\",\n      \"password\": \"RY\",\n      \"dbType\": \"oracle\",\n      \"isIgnorecase\": \"1\",\n      \"excludeSchema\": []\n    }";
      JdbcUtil.initData(content);

      try {
         Thread.sleep(2000L);
      } catch (InterruptedException e) {
         e.printStackTrace();
      }

      Map<String, String> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "oracle");
      params.put("schema", "TEST");
      params.put("url", "jdbc:oracle:thin:@192.168.2.103:1521:TEST");
      SqlUtil sqlUtil = new SqlUtil();
      Map<String, Object> stringObjectMap = sqlUtil.parseSqlStructureAnd(params);
      System.out.println(stringObjectMap);
      return stringObjectMap;
   }
}
