package com.alibaba.druid.sql.ast;

import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLDataTypeRefExpr extends SQLExprImpl {
   private SQLDataType dataType;

   public SQLDataTypeRefExpr(SQLDataType dataType) {
      this.dataType = dataType;
   }

   public SQLDataType getDataType() {
      return this.dataType;
   }

   public void setDataType(SQLDataType x) {
      if (x != null) {
         x.setParent(this);
      }

      this.dataType = x;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLDataTypeRefExpr that = (SQLDataTypeRefExpr)o;
         return this.dataType != null ? this.dataType.equals(that.dataType) : that.dataType == null;
      } else {
         return false;
      }
   }

   public int hashCode() {
      return this.dataType != null ? this.dataType.hashCode() : 0;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.dataType);
      }

      v.endVisit(this);
   }

   public SQLExpr clone() {
      return new SQLDataTypeRefExpr(this.dataType == null ? null : this.dataType.clone());
   }
}
