package com.alibaba.druid.sql.ast;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.Collections;
import java.util.List;

public class SQLMapDataType extends SQLObjectImpl implements SQLDataType {
   public static final SQLMapDataType MAP_CHAR_CHAR;
   private DbType dbType;
   private SQLDataType keyType;
   private SQLDataType valueType;

   public SQLMapDataType() {
   }

   public SQLMapDataType(SQLDataType keyType, SQLDataType valueType) {
      this.setKeyType(keyType);
      this.setValueType(valueType);
   }

   public SQLMapDataType(SQLDataType keyType, SQLDataType valueType, DbType dbType) {
      this.setKeyType(keyType);
      this.setValueType(valueType);
      this.dbType = dbType;
   }

   public String getName() {
      return "MAP";
   }

   public long nameHashCode64() {
      return FnvHash.Constants.MAP;
   }

   public void setName(String name) {
      throw new UnsupportedOperationException();
   }

   public List<SQLExpr> getArguments() {
      return Collections.emptyList();
   }

   public Boolean getWithTimeZone() {
      return null;
   }

   public void setWithTimeZone(Boolean value) {
      throw new UnsupportedOperationException();
   }

   public boolean isWithLocalTimeZone() {
      return false;
   }

   public void setWithLocalTimeZone(boolean value) {
      throw new UnsupportedOperationException();
   }

   public void setDbType(DbType dbType) {
   }

   public DbType getDbType() {
      return this.dbType;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.keyType);
         this.acceptChild(visitor, this.valueType);
      }

      visitor.endVisit(this);
   }

   public SQLMapDataType clone() {
      SQLMapDataType x = new SQLMapDataType();
      x.dbType = this.dbType;
      if (this.keyType != null) {
         x.setKeyType(this.keyType.clone());
      }

      if (this.valueType != null) {
         x.setValueType(this.valueType.clone());
      }

      return x;
   }

   public SQLDataType getKeyType() {
      return this.keyType;
   }

   public void setKeyType(SQLDataType x) {
      if (x != null) {
         x.setParent(this);
      }

      this.keyType = x;
   }

   public SQLDataType getValueType() {
      return this.valueType;
   }

   public void setValueType(SQLDataType x) {
      if (x != null) {
         x.setParent(this);
      }

      this.valueType = x;
   }

   public int jdbcType() {
      return 1111;
   }

   public boolean isInt() {
      return false;
   }

   public boolean isNumberic() {
      return false;
   }

   public boolean isString() {
      return false;
   }

   public boolean hasKeyLength() {
      return false;
   }

   static {
      MAP_CHAR_CHAR = new SQLMapDataType(SQLCharExpr.DATA_TYPE, SQLCharExpr.DATA_TYPE);
   }
}
