package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class SQLInSubQueryExpr extends SQLExprImpl implements Serializable, SQLReplaceable {
   private static final long serialVersionUID = 1L;
   private boolean not = false;
   private SQLExpr expr;
   public SQLSelect subQuery;
   public SQLCommentHint hint;
   private boolean global;

   public SQLInSubQueryExpr() {
   }

   public SQLInSubQueryExpr(SQLSelect select) {
      this.setSubQuery(select);
   }

   public SQLInSubQueryExpr(SQLExpr expr, SQLSelectQueryBlock queryBlock) {
      this.setExpr(expr);
      this.setSubQuery(new SQLSelect(queryBlock));
   }

   public SQLInSubQueryExpr clone() {
      SQLInSubQueryExpr x = new SQLInSubQueryExpr();
      x.not = this.not;
      x.global = this.global;
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      if (this.subQuery != null) {
         x.setSubQuery(this.subQuery.clone());
      }

      return x;
   }

   public boolean isNot() {
      return this.not;
   }

   public void setNot(boolean not) {
      this.not = not;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   public SQLSelect getSubQuery() {
      return this.subQuery;
   }

   public void setSubQuery(SQLSelect x) {
      if (x != null) {
         x.setParent(this);
      }

      this.subQuery = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.expr != null) {
            this.expr.accept(visitor);
         }

         if (this.subQuery != null) {
            this.subQuery.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Arrays.asList(this.expr, this.subQuery);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
      result = 31 * result + (this.not ? 1231 : 1237);
      result = 31 * result + (this.global ? 1231 : 1237);
      result = 31 * result + (this.subQuery == null ? 0 : this.subQuery.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLInSubQueryExpr other = (SQLInSubQueryExpr)obj;
         if (this.expr == null) {
            if (other.expr != null) {
               return false;
            }
         } else if (!this.expr.equals(other.expr)) {
            return false;
         }

         if (this.not != other.not) {
            return false;
         } else if (this.global != other.global) {
            return false;
         } else {
            if (this.subQuery == null) {
               if (other.subQuery != null) {
                  return false;
               }
            } else if (!this.subQuery.equals(other.subQuery)) {
               return false;
            }

            return true;
         }
      }
   }

   public SQLDataType computeDataType() {
      return SQLBooleanExpr.DATA_TYPE;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else {
         return false;
      }
   }

   public SQLCommentHint getHint() {
      return this.hint;
   }

   public void setHint(SQLCommentHint hint) {
      this.hint = hint;
   }

   public boolean isGlobal() {
      return this.global;
   }

   public void setGlobal(boolean global) {
      this.global = global;
   }
}
