package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLSmallIntExpr extends SQLNumericLiteralExpr implements SQLValuableExpr {
   private Short value;

   public SQLSmallIntExpr() {
   }

   public SQLSmallIntExpr(short value) {
      this.value = value;
   }

   public SQLSmallIntExpr(String value) {
      if (value.startsWith("--")) {
         value = value.substring(2);
      }

      this.value = Short.valueOf(value);
   }

   public SQLSmallIntExpr clone() {
      return new SQLSmallIntExpr(this.value);
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }

   public Number getNumber() {
      return this.value;
   }

   public Short getValue() {
      return this.value;
   }

   public void setValue(Short value) {
      this.value = value;
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLSmallIntExpr other = (SQLSmallIntExpr)obj;
         if (this.value == null) {
            if (other.value != null) {
               return false;
            }
         } else if (!this.value.equals(other.value)) {
            return false;
         }

         return true;
      }
   }

   public void setNumber(Number number) {
      if (number == null) {
         this.setValue((Short)null);
      } else {
         this.setValue((Short)number);
      }
   }
}
