package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLCreateProcedureStatement extends SQLStatementImpl implements SQLCreateStatement {
   private SQLName definer;
   private boolean create = true;
   private boolean orReplace;
   private SQLName name;
   private SQLStatement block;
   private List<SQLParameter> parameters = new ArrayList();
   private boolean ifNotExists = false;
   private String javaCallSpec;
   private SQLName authid;
   private boolean deterministic;
   private boolean containsSql;
   private boolean noSql;
   private boolean readSqlData;
   private boolean modifiesSqlData;
   private boolean languageSql;
   private String wrappedSource;
   private SQLCharExpr comment;

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.definer);
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.parameters);
         this.acceptChild(visitor, this.block);
         this.acceptChild(visitor, this.comment);
      }

      visitor.endVisit(this);
   }

   public List<SQLParameter> getParameters() {
      return this.parameters;
   }

   public void setParameters(List<SQLParameter> parameters) {
      this.parameters = parameters;
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
   }

   public SQLStatement getBlock() {
      return this.block;
   }

   public void setBlock(SQLStatement block) {
      if (block != null) {
         block.setParent(this);
      }

      this.block = block;
   }

   public SQLName getAuthid() {
      return this.authid;
   }

   public void setAuthid(SQLName authid) {
      if (authid != null) {
         authid.setParent(this);
      }

      this.authid = authid;
   }

   public boolean isOrReplace() {
      return this.orReplace;
   }

   public void setOrReplace(boolean orReplace) {
      this.orReplace = orReplace;
   }

   public SQLName getDefiner() {
      return this.definer;
   }

   public void setDefiner(SQLName definer) {
      this.definer = definer;
   }

   public boolean isCreate() {
      return this.create;
   }

   public void setCreate(boolean create) {
      this.create = create;
   }

   public String getJavaCallSpec() {
      return this.javaCallSpec;
   }

   public void setJavaCallSpec(String javaCallSpec) {
      this.javaCallSpec = javaCallSpec;
   }

   public boolean isDeterministic() {
      return this.deterministic;
   }

   public void setDeterministic(boolean deterministic) {
      this.deterministic = deterministic;
   }

   public boolean isContainsSql() {
      return this.containsSql;
   }

   public void setContainsSql(boolean containsSql) {
      this.containsSql = containsSql;
   }

   public boolean isNoSql() {
      return this.noSql;
   }

   public void setNoSql(boolean noSql) {
      this.noSql = noSql;
   }

   public boolean isReadSqlData() {
      return this.readSqlData;
   }

   public void setReadSqlData(boolean readSqlData) {
      this.readSqlData = readSqlData;
   }

   public boolean isModifiesSqlData() {
      return this.modifiesSqlData;
   }

   public void setModifiesSqlData(boolean modifiesSqlData) {
      this.modifiesSqlData = modifiesSqlData;
   }

   public SQLParameter findParameter(long hash) {
      for(SQLParameter param : this.parameters) {
         if (param.getName().nameHashCode64() == hash) {
            return param;
         }
      }

      return null;
   }

   public boolean isLanguageSql() {
      return this.languageSql;
   }

   public void setLanguageSql(boolean languageSql) {
      this.languageSql = languageSql;
   }

   public SQLCharExpr getComment() {
      return this.comment;
   }

   public void setComment(SQLCharExpr comment) {
      if (comment != null) {
         comment.setParent(this);
      }

      this.comment = comment;
   }

   public String getWrappedSource() {
      return this.wrappedSource;
   }

   public void setWrappedSource(String wrappedSource) {
      this.wrappedSource = wrappedSource;
   }

   public boolean isIfNotExists() {
      return this.ifNotExists;
   }

   public void setIfNotExists(boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
   }
}
