package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLShowCreateMaterializedViewStatement extends SQLStatementImpl implements SQLShowStatement {
   private SQLExpr name;

   public SQLShowCreateMaterializedViewStatement() {
   }

   public SQLShowCreateMaterializedViewStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      return children;
   }
}
