package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLValuesQuery extends SQLObjectImpl implements SQLSelectQuery {
   private boolean bracket = false;
   private List<SQLExpr> values = new ArrayList();

   public List<SQLExpr> getValues() {
      return this.values;
   }

   public void addValue(SQLListExpr value) {
      value.setParent(this);
      this.values.add(value);
   }

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.values);
      }

      visitor.endVisit(this);
   }

   public boolean isBracket() {
      return this.bracket;
   }

   public void setBracket(boolean bracket) {
      this.bracket = bracket;
   }

   public SQLValuesQuery clone() {
      SQLValuesQuery x = new SQLValuesQuery();
      x.bracket = this.bracket;

      for(int i = 0; i < this.values.size(); ++i) {
         SQLExpr value = ((SQLExpr)this.values.get(i)).clone();
         value.setParent(x);
         x.values.add(value);
      }

      return x;
   }
}
