package com.alibaba.druid.sql.dialect.db2.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLAlterIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import util.sqlparse.visitor.common.Objects;

public class DB2AlterIndexStatement extends SQLAlterIndexStatement implements DB2SQLStatement, SQLAlterStatement {
   private SQLName newName;
   private List<SQLExpr> itemList = new ArrayList();
   private List<SQLUpdateSetItem> parameterList = new ArrayList();
   private SQLExpr newTableSpace;
   private List<SQLExpr> roleList = new ArrayList();
   private boolean setIfExists;
   private boolean setNowait;
   private boolean setTableSpace;
   private boolean setAllIn;
   private boolean setOwnedBy;
   private boolean reorganize;
   private boolean on;
   private SQLExpr tableName;
   private SetType type;
   private List<SQLExpr> values;

   public boolean isReorganize() {
      return this.reorganize;
   }

   public void setReorganize(boolean reorganize) {
      this.reorganize = reorganize;
   }

   public boolean isOn() {
      return this.on;
   }

   public void setOn(boolean on) {
      this.on = on;
   }

   public SQLExpr getTableName() {
      return this.tableName;
   }

   public void setTableName(SQLExpr tableName) {
      this.tableName = tableName;
   }

   public DB2AlterIndexStatement() {
      this.type = SetType.None;
      this.values = new ArrayList();
      this.dbType = DbType.db2;
   }

   public SQLName getNewName() {
      return this.newName;
   }

   public void setNewName(SQLName newName) {
      this.newName = newName;
      if (newName != null) {
         newName.setParent(this);
      }

   }

   public List<SQLExpr> getValues() {
      return this.values;
   }

   public void setValues(List<SQLExpr> values) {
      this.values = values;
   }

   public void addValue(SQLExpr value) {
      this.values.add(value);
      value.setParent(this);
   }

   public SetType getType() {
      return this.type;
   }

   public void setType(SetType type) {
      this.type = type;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getName());
         this.acceptChild(visitor, this.newName);
         this.acceptChild(visitor, this.parameterList);
         this.acceptChild(visitor, this.roleList);
         this.acceptChild(visitor, this.newTableSpace);
         this.acceptChild(visitor, this.values);
      }

      visitor.endVisit(this);
   }

   public List<SQLUpdateSetItem> getParameterList() {
      return this.parameterList;
   }

   public void setParameterList(List<SQLUpdateSetItem> parameterList) {
      this.parameterList = parameterList;
   }

   public SQLExpr getNewTableSpace() {
      return this.newTableSpace;
   }

   public void setNewTableSpace(SQLExpr newTableSpace) {
      this.newTableSpace = newTableSpace;
   }

   public List<SQLExpr> getRoleList() {
      return this.roleList;
   }

   public void setRoleList(List<SQLExpr> roleList) {
      this.roleList = roleList;
   }

   public boolean isSetNowait() {
      return this.setNowait;
   }

   public void setSetNowait(boolean setNowait) {
      this.setNowait = setNowait;
   }

   public boolean isSetTableSpace() {
      return this.setTableSpace;
   }

   public void setSetTableSpace(boolean setTableSpace) {
      this.setTableSpace = setTableSpace;
   }

   public boolean isSetAllIn() {
      return this.setAllIn;
   }

   public void setSetAllIn(boolean setAllIn) {
      this.setAllIn = setAllIn;
   }

   public boolean isSetOwnedBy() {
      return this.setOwnedBy;
   }

   public void setSetOwnedBy(boolean setOwnedBy) {
      this.setOwnedBy = setOwnedBy;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         DB2AlterIndexStatement that = (DB2AlterIndexStatement)o;
         return this.setNowait == that.setNowait && this.setTableSpace == that.setTableSpace && this.setAllIn == that.setAllIn && this.setOwnedBy == that.setOwnedBy && Objects.equals(this.newName, that.newName) && Objects.equals(this.parameterList, that.parameterList) && Objects.equals(this.newTableSpace, that.newTableSpace) && Objects.equals(this.roleList, that.roleList) && this.type == that.type && Objects.equals(this.values, that.values);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(this.newName, this.parameterList, this.newTableSpace, this.roleList, this.setNowait, this.setTableSpace, this.setAllIn, this.setOwnedBy, this.type, this.values);
   }

   public boolean isSetIfExists() {
      return this.setIfExists;
   }

   public void setSetIfExists(boolean setIfExists) {
      this.setIfExists = setIfExists;
   }

   public List<SQLExpr> getItemList() {
      return this.itemList;
   }

   public void setItemList(List<SQLExpr> itemList) {
      this.itemList = itemList;
   }

   public static enum SetType {
      None,
      Reset,
      Set;
   }
}
