package com.alibaba.druid.sql.dialect.dm.ast;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public abstract class DmSQLObjectImpl extends SQLObjectImpl implements DMSQLObject {
   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public abstract void accept0(DmASTVisitor var1);

   public DMSQLObject clone() {
      throw new UnsupportedOperationException(this.getClass().getName());
   }

   public SQLDataType computeDataType() {
      return null;
   }

   public String toString() {
      return SQLUtils.toDmString(this);
   }
}
