package com.alibaba.druid.sql.dialect.gauss.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class GaussTypeCastExpr extends SQLCastExpr implements GaussExpr {
   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.dataType);
      }

      visitor.endVisit(this);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof GaussASTVisitor) {
         this.accept0((GaussASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }
   }

   public String toString() {
      return SQLUtils.toPGString(this);
   }
}
