package com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.greenplum.ast.GPSQLObjectImpl;
import com.alibaba.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class GPAlterTableSetWith extends GPSQLObjectImpl implements SQLAlterTableItem {
   private boolean withReorgnize = false;
   private DistributeType distributeType;
   private List<GPAlterTableDistributeByOption> options = new ArrayList();

   public boolean isWithReorgnize() {
      return this.withReorgnize;
   }

   public void setWithReorgnize(boolean withReorgnize) {
      this.withReorgnize = withReorgnize;
   }

   public DistributeType getDistributeType() {
      return this.distributeType;
   }

   public void setDistributeType(DistributeType distributeType) {
      this.distributeType = distributeType;
   }

   public List<GPAlterTableDistributeByOption> getOptions() {
      return this.options;
   }

   public void setOptions(List<GPAlterTableDistributeByOption> options) {
      this.options = options;
   }

   public void addOption(GPAlterTableDistributeByOption option) {
      this.options.add(option);
      option.setParent(this);
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.options);
      }

      visitor.endVisit(this);
   }

   public GPAlterTableSetWith clone() {
      GPAlterTableSetWith c = new GPAlterTableSetWith();
      c.distributeType = this.distributeType;
      c.withReorgnize = this.withReorgnize;
      if (this.options != null && this.options.size() > 0) {
         for(GPAlterTableDistributeByOption option : this.options) {
            c.addOption(option.clone());
         }
      }

      return c;
   }

   public static class GPAlterTableDistributeByOption extends GPSQLObjectImpl {
      private SQLExpr columnName;
      private SQLExpr opClass;

      public SQLExpr getColumnName() {
         return this.columnName;
      }

      public void setColumnName(SQLExpr columnName) {
         columnName.setParent(this);
         this.columnName = columnName;
      }

      public SQLExpr getOpClass() {
         return this.opClass;
      }

      public void setOpClass(SQLExpr opClass) {
         opClass.setParent(this);
         this.opClass = opClass;
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((GPASTVisitor)visitor);
      }

      public void accept0(GPASTVisitor visitor) {
         if (visitor.visit(this)) {
            if (this.columnName != null) {
               this.columnName.accept(visitor);
            }

            if (this.opClass != null) {
               this.opClass.accept(visitor);
            }
         }

         visitor.endVisit(this);
      }

      public GPAlterTableDistributeByOption clone() {
         GPAlterTableDistributeByOption o = new GPAlterTableDistributeByOption();
         o.setColumnName(this.columnName.clone());
         if (this.opClass != null) {
            o.setOpClass(this.opClass.clone());
         }

         return o;
      }
   }

   public static enum DistributeType {
      with,
      by,
      randomly,
      replicated;
   }
}
