package com.alibaba.druid.sql.dialect.hive.ast.expr;

import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;

public class HiveCharExpr extends SQLCharExpr implements HiveExpr {
   private String charset;
   private String collate;
   private String type;

   public HiveCharExpr() {
   }

   public HiveCharExpr(String text) {
      super(text);
   }

   public HiveCharExpr(String text, String charset) {
      super(text);
      this.charset = charset;
   }

   public HiveCharExpr(String text, String charset, String collate) {
      super(text);
      this.charset = charset;
      this.collate = collate;
   }

   public String getCharset() {
      return this.charset;
   }

   public void setCharset(String charset) {
      this.charset = charset;
   }

   public String getCollate() {
      return this.collate;
   }

   public void setCollate(String collate) {
      this.collate = collate;
   }

   public String getType() {
      return this.type;
   }

   public void setType(String type) {
      this.type = type;
   }

   public void output(Appendable buf) {
      try {
         if (this.charset != null) {
            buf.append(this.charset);
            buf.append(' ');
         }

         if (super.text != null) {
            super.output(buf);
         }

         if (this.collate != null) {
            buf.append(" COLLATE ");
            buf.append(this.collate);
         }

      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MySqlASTVisitor) {
         this.accept0((MySqlASTVisitor)visitor);
      } else {
         visitor.visit((SQLCharExpr)this);
         visitor.endVisit((SQLCharExpr)this);
      }

   }

   public void accept0(MySqlASTVisitor visitor) {
      visitor.visit((SQLCharExpr)this);
      visitor.endVisit((SQLCharExpr)this);
   }

   public String toString() {
      StringBuffer buf = new StringBuffer();
      this.output(buf);
      return buf.toString();
   }

   public HiveCharExpr clone() {
      HiveCharExpr x = new HiveCharExpr(this.text);
      x.collate = this.collate;
      x.charset = this.charset;
      x.type = this.type;
      return x;
   }

   public void accept0(HiveASTVisitor visitor) {
   }
}
