package com.alibaba.druid.sql.dialect.mariadb.ast.clause;

import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.dialect.mariadb.ast.statement.MariadbStatementImpl;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MariadbDeclareStatement extends MariadbStatementImpl {
   private List<SQLDeclareItem> varList = new ArrayList();

   public List<SQLDeclareItem> getVarList() {
      return this.varList;
   }

   public void addVar(SQLDeclareItem expr) {
      this.varList.add(expr);
   }

   public void setVarList(List<SQLDeclareItem> varList) {
      this.varList = varList;
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.varList);
      }

      visitor.endVisit(this);
   }

   public List getChildren() {
      return this.varList;
   }
}
