lexer grammar JsLexer;

COLON :':';
COMMA: ',';
BOOLEAN_TRUE: 'true';
BOOLEAN_FALSE :'false';
NULL: 'null';
ID: [0-9a-zA-Z$_]+;
STRING  :  ( '"' (ESC | SAFECODEPOINT)* '"') | ( '\'' (ESC | SAFECODEPOINT)* '\'');
DOT : '.';
NUMBER : '-'? INT ('.' [0-9] +)? EXP? ;
WS : [ \t\n\r] + -> skip ;
LPAREN : '(';
RPAREN : ')';
LBPAREN : '{';
RBPAREN: '}';
LSQUARE: '[';
RSQUARE: ']';
fragment ESC : '\\' (["\\/bfnrt] | UNICODE) ;
fragment UNICODE : 'u' HEX HEX HEX HEX ;
fragment HEX : [0-9a-fA-F] ;
fragment SAFECODEPOINT : ~ ["\\\u0000-\u001F] ;
fragment INT : '0' | [1-9] [0-9]* ;
fragment EXP : [Ee] [+\-]? INT ;
