package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlObjectImpl;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlExtPartition extends MySqlObjectImpl implements Cloneable {
   private final List<Item> items = new ArrayList();

   public List<Item> getItems() {
      return this.items;
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         for(int i = 0; i < this.items.size(); ++i) {
            ((Item)this.items.get(i)).accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public MySqlExtPartition clone() {
      MySqlExtPartition x = new MySqlExtPartition();

      for(Item item : this.items) {
         Item item1 = item.clone();
         item1.setParent(x);
         x.items.add(item1);
      }

      return x;
   }

   public static class Item extends MySqlObjectImpl implements Cloneable {
      private SQLName dbPartition;
      private SQLExpr dbPartitionBy;
      private SQLName tbPartition;
      private SQLExpr tbPartitionBy;

      public void accept0(MySqlASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.dbPartition);
            this.acceptChild(visitor, this.dbPartitionBy);
            this.acceptChild(visitor, this.tbPartition);
            this.acceptChild(visitor, this.tbPartitionBy);
         }

         visitor.endVisit(this);
      }

      public Item clone() {
         Item x = new Item();
         if (this.dbPartition != null) {
            x.setDbPartition(this.dbPartition.clone());
         }

         if (this.dbPartitionBy != null) {
            x.setDbPartitionBy(this.dbPartitionBy.clone());
         }

         if (this.tbPartition != null) {
            x.setTbPartition(this.tbPartition.clone());
         }

         if (this.tbPartitionBy != null) {
            x.setTbPartitionBy(this.tbPartitionBy.clone());
         }

         return x;
      }

      public SQLName getDbPartition() {
         return this.dbPartition;
      }

      public void setDbPartition(SQLName x) {
         if (x != null) {
            x.setParent(this);
         }

         this.dbPartition = x;
      }

      public SQLName getTbPartition() {
         return this.tbPartition;
      }

      public void setTbPartition(SQLName x) {
         if (x != null) {
            x.setParent(this);
         }

         this.tbPartition = x;
      }

      public SQLExpr getDbPartitionBy() {
         return this.dbPartitionBy;
      }

      public void setDbPartitionBy(SQLExpr x) {
         if (x != null) {
            x.setParent(this);
         }

         this.dbPartitionBy = x;
      }

      public SQLExpr getTbPartitionBy() {
         return this.tbPartitionBy;
      }

      public void setTbPartitionBy(SQLExpr x) {
         if (x != null) {
            x.setParent(this);
         }

         this.tbPartitionBy = x;
      }
   }
}
