package com.alibaba.druid.sql.dialect.oracle.ast;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public abstract class OracleSQLObjectImpl extends SQLObjectImpl implements OracleSQLObject {
   protected void accept0(SQLASTVisitor v) {
      if (v instanceof OracleASTVisitor) {
         this.accept0((OracleASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public abstract void accept0(OracleASTVisitor var1);

   public OracleSQLObject clone() {
      throw new UnsupportedOperationException(this.getClass().getName());
   }

   public SQLDataType computeDataType() {
      return null;
   }

   public String toString() {
      return SQLUtils.toOracleString(this);
   }
}
