package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.PartitionExtensionClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SampleClause;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class OracleSelectTableReference extends SQLExprTableSource implements OracleSelectTableSource {
   private boolean only = false;
   protected OracleSelectPivotBase pivot;
   protected PartitionExtensionClause partition;
   protected SampleClause sampleClause;

   public OracleSelectTableReference() {
   }

   public OracleSelectTableReference(SQLExpr expr) {
      this.setExpr(expr);
   }

   public PartitionExtensionClause getPartition() {
      return this.partition;
   }

   public void setPartition(PartitionExtensionClause partition) {
      if (partition != null) {
         partition.setParent(this);
      }

      this.partition = partition;
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public SampleClause getSampleClause() {
      return this.sampleClause;
   }

   public void setSampleClause(SampleClause sampleClause) {
      if (sampleClause != null) {
         sampleClause.setParent(this);
      }

      this.sampleClause = sampleClause;
   }

   public OracleSelectPivotBase getPivot() {
      return this.pivot;
   }

   public void setPivot(OracleSelectPivotBase pivot) {
      if (pivot != null) {
         pivot.setParent(this);
      }

      this.pivot = pivot;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof OracleASTVisitor) {
         this.accept0((OracleASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   protected void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.partition);
         this.acceptChild(visitor, this.sampleClause);
         this.acceptChild(visitor, this.pivot);
      }

      visitor.endVisit(this);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         if (!super.equals(o)) {
            return false;
         } else {
            OracleSelectTableReference that = (OracleSelectTableReference)o;
            if (this.only != that.only) {
               return false;
            } else {
               if (this.pivot != null) {
                  if (!this.pivot.equals(that.pivot)) {
                     return false;
                  }
               } else if (that.pivot != null) {
                  return false;
               }

               if (this.partition != null) {
                  if (!this.partition.equals(that.partition)) {
                     return false;
                  }
               } else if (that.partition != null) {
                  return false;
               }

               if (this.sampleClause != null) {
                  if (!this.sampleClause.equals(that.sampleClause)) {
                     return false;
                  }
               } else if (that.sampleClause != null) {
                  return false;
               }

               return this.flashback != null ? this.flashback.equals(that.flashback) : that.flashback == null;
            }
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = super.hashCode();
      result = 31 * result + (this.only ? 1 : 0);
      result = 31 * result + (this.pivot != null ? this.pivot.hashCode() : 0);
      result = 31 * result + (this.partition != null ? this.partition.hashCode() : 0);
      result = 31 * result + (this.sampleClause != null ? this.sampleClause.hashCode() : 0);
      result = 31 * result + (this.flashback != null ? this.flashback.hashCode() : 0);
      return result;
   }

   public String toString() {
      return SQLUtils.toOracleString(this);
   }

   public OracleSelectTableReference clone() {
      OracleSelectTableReference x = new OracleSelectTableReference();
      this.cloneTo(x);
      x.only = this.only;
      if (this.pivot != null) {
         x.setPivot(this.pivot.clone());
      }

      if (this.partition != null) {
         x.setPartition(this.partition.clone());
      }

      if (this.sampleClause != null) {
         x.setSampleClause(this.sampleClause.clone());
      }

      if (this.flashback != null) {
         this.setFlashback(this.flashback.clone());
      }

      return x;
   }
}
