package com.alibaba.druid.sql.dialect.spark.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.spark.ast.expr.HiveRowFormat;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SparkCreateTableStatement extends SQLCreateTableStatement {
   protected List<SQLAssignItem> mappedBy = new ArrayList(1);
   protected List<SQLExpr> skewedBy = new ArrayList();
   protected List<SQLExpr> skewedByOn = new ArrayList();
   protected Map<String, SQLObject> serdeProperties = new LinkedHashMap();
   protected SQLExpr metaLifeCycle;
   protected SQLExprTableSource datasource;
   protected HiveRowFormat hiveFormat;
   protected SQLSelect bucketSelect;

   public SparkCreateTableStatement() {
      super(DbType.spark);
   }

   public List<SQLAssignItem> getMappedBy() {
      return this.mappedBy;
   }

   public List<SQLExpr> getSkewedBy() {
      return this.skewedBy;
   }

   public void addSkewedBy(SQLExpr item) {
      item.setParent(this);
      this.skewedBy.add(item);
   }

   public SQLSelect getBucketSelect() {
      return this.bucketSelect;
   }

   public void setBucketSelect(SQLSelect bucketSelect) {
      this.bucketSelect = bucketSelect;
   }

   public List<SQLExpr> getSkewedByOn() {
      return this.skewedByOn;
   }

   public void addSkewedByOn(SQLExpr item) {
      item.setParent(this);
      this.skewedByOn.add(item);
   }

   public Map<String, SQLObject> getSerdeProperties() {
      return this.serdeProperties;
   }

   public SQLExpr getMetaLifeCycle() {
      return this.metaLifeCycle;
   }

   public void setMetaLifeCycle(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.metaLifeCycle = x;
   }

   public void setDatasource(SQLExpr datasource) {
      this.datasource = new SQLExprTableSource(datasource);
   }

   public SQLExprTableSource getDatasource() {
      return this.datasource;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof SparkVisitor) {
         this.accept0((SparkVisitor)v);
      } else {
         super.accept0(v);
      }
   }

   protected void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v);
      }

      v.endVisit(this);
   }

   protected void acceptChild(SQLASTVisitor v) {
      super.acceptChild(v);
      this.acceptChild(v, this.datasource);
      this.acceptChild(v, this.skewedBy);
      this.acceptChild(v, this.skewedByOn);

      for(SQLObject item : this.serdeProperties.values()) {
         this.acceptChild(v, item);
      }

      this.acceptChild(v, this.metaLifeCycle);
   }

   public HiveRowFormat getHiveFormat() {
      return this.hiveFormat;
   }

   public void setHiveFormat(HiveRowFormat hiveFormat) {
      this.hiveFormat = hiveFormat;
   }
}
