package com.alibaba.druid.sql.dialect.spark.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.dialect.spark.ast.SparkSqlObject;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectTableReference;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import util.sqlparse.visitor.common.Objects;

public class SparkLoadStatement extends SQLStatementImpl implements SparkSqlObject {
   private boolean local;
   private SQLExpr inPath;
   private boolean overwrite;
   private SparkSelectTableReference table;

   public SparkLoadStatement() {
      this.dbType = DbType.spark;
   }

   public boolean isLocal() {
      return this.local;
   }

   public void setLocal(boolean local) {
      this.local = local;
   }

   public SQLExpr getInPath() {
      return this.inPath;
   }

   public void setInPath(SQLExpr inPath) {
      this.inPath = inPath;
   }

   public boolean isOverwrite() {
      return this.overwrite;
   }

   public void setOverwrite(boolean overwrite) {
      this.overwrite = overwrite;
   }

   public SparkSelectTableReference getTable() {
      return this.table;
   }

   public void setTable(SparkSelectTableReference table) {
      this.table = table;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((SparkVisitor)visitor);
   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.inPath);
         this.acceptChild(v, this.table);
      }

      v.endVisit(this);
   }

   public SparkLoadStatement clone() {
      SparkLoadStatement st = new SparkLoadStatement();
      st.local = this.local;
      st.overwrite = this.overwrite;
      if (this.inPath != null) {
         st.inPath = this.inPath.clone();
      }

      if (this.table != null) {
         st.table = this.table.clone();
      }

      return st;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SparkLoadStatement that = (SparkLoadStatement)o;
         return this.local == that.local && this.overwrite == that.overwrite && Objects.equals(this.inPath, that.inPath) && Objects.equals(this.table, that.table);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(this.local, this.inPath, this.overwrite, this.table);
   }
}
