package com.alibaba.druid.util;

import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.Calendar;
import java.util.TimeZone;

public class StringUtils {
   private static final Log LOG = LogFactory.getLog(StringUtils.class);

   private StringUtils() {
   }

   public static Integer subStringToInteger(String src, String start, String to) {
      return stringToInteger(subString(src, start, to));
   }

   public static String subString(String src, String start, String to) {
      return subString(src, start, to, false);
   }

   public static String subString(String src, String start, String to, boolean toLast) {
      int indexFrom = start == null ? 0 : src.indexOf(start);
      int indexTo;
      if (to == null) {
         indexTo = src.length();
      } else {
         indexTo = toLast ? src.lastIndexOf(to) : src.indexOf(to);
      }

      if (indexFrom >= 0 && indexTo >= 0 && indexFrom <= indexTo) {
         if (null != start) {
            indexFrom += start.length();
         }

         return src.substring(indexFrom, indexTo);
      } else {
         return null;
      }
   }

   public static Integer stringToInteger(String in) {
      if (in == null) {
         return null;
      } else {
         in = in.trim();
         if (in.length() == 0) {
            return null;
         } else {
            try {
               return Integer.parseInt(in);
            } catch (NumberFormatException e) {
               LOG.warn("stringToInteger fail,string=" + in, e);
               return null;
            }
         }
      }
   }

   public static boolean equals(String a, String b) {
      if (a == null) {
         return b == null;
      } else {
         return a.equals(b);
      }
   }

   public static boolean equalsIgnoreCase(String a, String b) {
      if (a == null) {
         return b == null;
      } else {
         return a.equalsIgnoreCase(b);
      }
   }

   public static boolean isEmpty(CharSequence value) {
      return value == null || value.length() == 0;
   }

   public static int lowerHashCode(String text) {
      if (text == null) {
         return 0;
      } else {
         int h = 0;

         for(int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
               ch = (char)(ch + 32);
            }

            h = 31 * h + ch;
         }

         return h;
      }
   }

   public static boolean isNumber(String str) {
      if (str != null && str.length() != 0) {
         int sz = str.length();
         boolean hasExp = false;
         boolean hasDecPoint = false;
         boolean allowSigns = false;
         boolean foundDigit = false;
         int start = str.charAt(0) == '-' ? 1 : 0;
         if (sz > start + 1 && str.charAt(start) == '0' && str.charAt(start + 1) == 'x') {
            int i = start + 2;
            if (i == sz) {
               return false;
            } else {
               while(i < str.length()) {
                  char ch = str.charAt(i);
                  if ((ch < '0' || ch > '9') && (ch < 'a' || ch > 'f') && (ch < 'A' || ch > 'F')) {
                     return false;
                  }

                  ++i;
               }

               return true;
            }
         } else {
            --sz;

            int i;
            for(i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
               char ch = str.charAt(i);
               if (ch >= '0' && ch <= '9') {
                  foundDigit = true;
                  allowSigns = false;
               } else if (ch == '.') {
                  if (hasDecPoint || hasExp) {
                     return false;
                  }

                  hasDecPoint = true;
               } else if (ch != 'e' && ch != 'E') {
                  if (ch != '+' && ch != '-') {
                     return false;
                  }

                  if (!allowSigns) {
                     return false;
                  }

                  allowSigns = false;
                  foundDigit = false;
               } else {
                  if (hasExp) {
                     return false;
                  }

                  if (!foundDigit) {
                     return false;
                  }

                  hasExp = true;
                  allowSigns = true;
               }
            }

            if (i < str.length()) {
               char ch = str.charAt(i);
               if (ch >= '0' && ch <= '9') {
                  return true;
               } else if (ch != 'e' && ch != 'E') {
                  if (allowSigns || ch != 'd' && ch != 'D' && ch != 'f' && ch != 'F') {
                     if (ch != 'l' && ch != 'L') {
                        return false;
                     } else {
                        return foundDigit && !hasExp;
                     }
                  } else {
                     return foundDigit;
                  }
               } else {
                  return false;
               }
            } else {
               return !allowSigns && foundDigit;
            }
         }
      } else {
         return false;
      }
   }

   public static boolean isNumber(char[] chars) {
      if (chars != null && chars.length != 0) {
         int sz = chars.length;
         boolean hasExp = false;
         boolean hasDecPoint = false;
         boolean allowSigns = false;
         boolean foundDigit = false;
         int start = chars[0] == '-' ? 1 : 0;
         if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i = start + 2;
            if (i == sz) {
               return false;
            } else {
               while(i < chars.length) {
                  char ch = chars[i];
                  if ((ch < '0' || ch > '9') && (ch < 'a' || ch > 'f') && (ch < 'A' || ch > 'F')) {
                     return false;
                  }

                  ++i;
               }

               return true;
            }
         } else {
            --sz;

            int i;
            for(i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
               char ch = chars[i];
               if (ch >= '0' && ch <= '9') {
                  foundDigit = true;
                  allowSigns = false;
               } else if (ch == '.') {
                  if (hasDecPoint || hasExp) {
                     return false;
                  }

                  hasDecPoint = true;
               } else if (ch != 'e' && ch != 'E') {
                  if (ch != '+' && ch != '-') {
                     return false;
                  }

                  if (!allowSigns) {
                     return false;
                  }

                  allowSigns = false;
                  foundDigit = false;
               } else {
                  if (hasExp) {
                     return false;
                  }

                  if (!foundDigit) {
                     return false;
                  }

                  hasExp = true;
                  allowSigns = true;
               }
            }

            if (i < chars.length) {
               char ch = chars[i];
               if (ch >= '0' && ch <= '9') {
                  return true;
               } else if (ch != 'e' && ch != 'E') {
                  if (allowSigns || ch != 'd' && ch != 'D' && ch != 'f' && ch != 'F') {
                     if (ch != 'l' && ch != 'L') {
                        return ch == '.';
                     } else {
                        return foundDigit && !hasExp;
                     }
                  } else {
                     return foundDigit;
                  }
               } else {
                  return false;
               }
            } else {
               return !allowSigns && foundDigit;
            }
         }
      } else {
         return false;
      }
   }

   public static String formatDateTime19(long millis, TimeZone timeZone) {
      Calendar cale = timeZone == null ? Calendar.getInstance() : Calendar.getInstance(timeZone);
      cale.setTimeInMillis(millis);
      int year = cale.get(1);
      int month = cale.get(2) + 1;
      int dayOfMonth = cale.get(5);
      int hour = cale.get(11);
      int minute = cale.get(12);
      int second = cale.get(13);
      char[] chars = new char[19];
      chars[0] = (char)(year / 1000 + 48);
      chars[1] = (char)(year / 100 % 10 + 48);
      chars[2] = (char)(year / 10 % 10 + 48);
      chars[3] = (char)(year % 10 + 48);
      chars[4] = '-';
      chars[5] = (char)(month / 10 + 48);
      chars[6] = (char)(month % 10 + 48);
      chars[7] = '-';
      chars[8] = (char)(dayOfMonth / 10 + 48);
      chars[9] = (char)(dayOfMonth % 10 + 48);
      chars[10] = ' ';
      chars[11] = (char)(hour / 10 + 48);
      chars[12] = (char)(hour % 10 + 48);
      chars[13] = ':';
      chars[14] = (char)(minute / 10 + 48);
      chars[15] = (char)(minute % 10 + 48);
      chars[16] = ':';
      chars[17] = (char)(second / 10 + 48);
      chars[18] = (char)(second % 10 + 48);
      return new String(chars);
   }

   public static String removeNameQuotes(String s) {
      if (s != null && s.length() > 1) {
         int len = s.length();
         char c0 = s.charAt(0);
         char last = s.charAt(len - 1);
         return c0 != last || c0 != '`' && c0 != '\'' && c0 != '"' ? s : s.substring(1, len - 1);
      } else {
         return null;
      }
   }

   public static boolean isNotEmpty(CharSequence cs) {
      return !isEmpty(cs);
   }
}
