package com.palacesun.engine.common;

import java.util.HashMap;
import java.util.Map;
import util.sqlparse.visitor.common.scope.ReplaceInfo;

public class PreparedStatementInformation extends StatementInformation implements Loggable {
   private Map<String, Integer> digestMap = new HashMap();
   private ReplaceInfo replaceInfo;
   private final Map<Integer, Value> parameterValues = new HashMap();

   public ReplaceInfo getReplaceInfo() {
      return this.replaceInfo;
   }

   public void setReplaceInfo(ReplaceInfo replaceInfo) {
      this.replaceInfo = replaceInfo;
   }

   public PreparedStatementInformation(ConnectionInformation connectionInformation, String query) {
      super(connectionInformation);
      this.setStatementQuery(query);
   }

   public String getSqlWithValues() {
      StringBuilder sb = new StringBuilder();
      String statementQuery = this.getStatementQuery();
      int currentParameter = 0;

      for(int pos = 0; pos < statementQuery.length(); ++pos) {
         char character = statementQuery.charAt(pos);
         if (statementQuery.charAt(pos) == '?' && currentParameter <= this.parameterValues.size() && this.parameterValues.size() > 0) {
            try {
               String value = this.context.getBuffer().getRawValue(currentParameter + 1);
               sb.append(value);
            } catch (Exception var7) {
               sb.append("null");
            }

            ++currentParameter;
         } else {
            sb.append(character);
         }
      }

      return sb.toString();
   }

   public String getSqlWithSafeValues() {
      StringBuilder sb = new StringBuilder();
      String statementQuery = this.getStatementQuery();
      int currentParameter = 0;

      for(int pos = 0; pos < statementQuery.length(); ++pos) {
         char character = statementQuery.charAt(pos);
         if (statementQuery.charAt(pos) == '?' && currentParameter <= this.parameterValues.size() && this.parameterValues.size() > 0) {
            String value = this.context.getBuffer().getSafeValue(currentParameter + 1);
            sb.append(value);
            ++currentParameter;
         } else {
            sb.append(character);
         }
      }

      return sb.toString();
   }

   public void setParameterValue(int position, Object value) {
      this.parameterValues.put(position - 1, new Value(value));
   }

   protected Map<Integer, Value> getParameterValues() {
      return this.parameterValues;
   }

   public Map<String, Integer> getDigestMap() {
      return this.digestMap;
   }

   public void setDigestMap(Map<String, Integer> digestMap) {
      this.digestMap = digestMap;
   }
}
