package test.hive;

import bean.Column;
import java.util.ArrayList;
import java.util.Map;

public class DDLTest {
   public static String alter_1 = "ALTER DATABASE myhive SET DBPROPERTIES ('dt'='a');";
   public static String alter_2 = "ALTER DATABASE myhive SET owner user boyiming;";
   public static String alter_3 = "ALTER DATABASE myhive SET LOCATION '/tmp' ;";
   public static String alter_4 = "ALTER DATABASE myhive SET MANAGEDLOCATION '/tmp' ";
   public static String show_1 = "show tables;";
   public static String show_2 = "show create table test;";
   public static String dcl_1 = " begin transaction;";
   public static String create_database_1 = "create database test_1 ";
   public static String create_database_2 = "create database IF NOT EXISTS myhive comment 'this is my' with dbproperties('name'='lu','data'='2012-01-02');";
   public static String drop_database_1 = "drop database myhive";
   public static String create_table_1 = "create table test(id int,username string,password string)";
   public static String create_table_2 = "create EXTERNAL table IF NOT EXISTS user_2(id int,username string,password string)";
   public static String create_table_3 = "create temporary table myTable as select * from user_2;";
   public static String create_table_4 = "create table test(id int,username string,password string) COMMENT \"my_table\" PARTITIONED BY (dt string,country string)  CLUSTERED BY(id) SORTED BY(id) INTO 32 BUCKETS;";
   public static String create_table_5 = "create table test_9(id int,username string,password string)  PARTITIONED BY (dt string,country string)  CLUSTERED BY(id) SORTED BY(id) INTO 32 BUCKETS SKEWED BY (id) ON (1,5,6);";
   public static String create_table_6 = "create table test_5(id int,username string,password string) COMMENT  \"my_table\" PARTITIONED BY (dt string,country string) CLUSTERED BY(id) SORTED BY(id) INTO 32  BUCKETS SKEWED BY (id) ON (1,5,6) TBLPROPERTIES('EXTERNAL'='FALSE')";
   public static String create_table_7 = "create table test_14(id int,username string,password string) ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde' WITH SERDEPROPERTIES (\"separatorChar\" = \"\\t\",\"quoteChar\" = \"'\",\"escapeChar\" = \"\\\\\") STORED AS TEXTFILE;\n";
   public static String create_table_8 = "create table test_15(id int,username string,password string)  ROW FORMAT DELIMITED  FIELDS TERMINATED BY ',' COLLECTION ITEMS TERMINATED BY '-' MAP KEYS TERMINATED BY ':';";
   public static String create_table_9 = "create table test_16(id int,username string,password string) location '/tmp/dkl/internal_location';";
   public static String create_table_10 = "create table test_16(id int,username string,password string) location '/tmp/dkl/internal_location' TBLPROPERTIES('EXTERNAL'='FALSE');";
   public static String create_table_11 = "create table test_28 as select * from user_2;";
   public static String create_table_12 = "create table test_28(id int,username string)  as select id,username, from user_2;";
   public static String create_table_13 = "create table users_2 as with q1 as ( select id from user_1 where id = '4') select * from q1;";
   public static String create_table_14 = "create table users_1 as select id from user_1 where id = '4';";
   public static String create_table_15 = "CREATE TABLE user_11 LIKE user_2;";
   public static String create_table_16 = "create table users_15(id int, PRIMARY KEY(id) disable novalidate);";
   public static String drop_table_1 = "drop table if EXISTS test_17;";
   public static String truncate_1 = "truncate table users_1;";
   public static String truncate_2 = "truncate table users_1 PARTITION(dt='2028');";
   public static String create_view_1 = " CREATE VIEW  IF NOT EXISTS bym.view_1 (id,name) COMMENT \"my_view\" TBLPROPERTIES ('name'='lu') AS SELECT id from user_1";
   public static String drop_view_1 = "drop view if EXISTS view_17;";
   public static String create_Materialized_1 = "CREATE Materialized VIEW IF NOT EXISTS view_3 COMMENT 'my_view' TBLPROPERTIES ('name' = 'lu' ) AS SELECT id FROM user_1;";
   public static String function_1 = "CREATE TEMPORARY FUNCTION function_name AS class_name;";
   public static String function_2 = "CREATE FUNCTION function_name AS class_name;";
   public static String drop_function_1 = "drop TEMPORARY function_name;";
   public static String MACRO_1 = "CREATE TEMPORARY MACRO simple_add (x int, y int) x + y;";
   public static String drop_MACRO_1 = "drop TEMPORARY MACRO simple_add ;";
   public static String create_index_1 = "create index u_id on table user_1(id) as 'org.apache.hadoop.hive.ql.index.compact.CompactIndexHandler' with deferred rebuild;";
   public static String drop_index_1 = "drop index u_id on user_1";

   public static void main(String[] args) {
      ExecTest p = new ExecTest();
      Map<String, Object> res = p.execSqlPrase(alter_1);
      print(res);
   }

   public static void print(Map<String, Object> res) {
      System.out.println("\n\n====sql====");
      System.out.println(res.get("sql"));
      System.out.println("\n\n====type====");
      System.out.println(res.get("type"));
      System.out.println("\n\n====schemaMap====");
      Map<String, Object> schemaMap = (Map)res.get("schemaMap");
      if (schemaMap != null && !schemaMap.isEmpty()) {
         for(Map.Entry<String, Object> item : schemaMap.entrySet()) {
            System.out.println((String)item.getKey() + "\t" + item.getValue());
         }
      }

      System.out.println("\n\n====tableMap====");
      Map<String, Object> tableMap = (Map)res.get("tableMap");
      if (tableMap != null && !tableMap.isEmpty()) {
         for(Map.Entry<String, Object> item : tableMap.entrySet()) {
            System.out.println((String)item.getKey() + "\t" + item.getValue());
         }
      }

      System.out.println("\n\n====columnList====");
      ArrayList<Column> columnList = (ArrayList)res.get("columnList");
      String[] var10000 = new String[]{"columnName", "columnAlisa", "fullName", "nowName", "dataType", "schema", "table", "value", "expr"};

      for(int i = 0; i < columnList.size(); ++i) {
         System.out.println(((Column)columnList.get(i)).getColumnName());
      }

      System.out.println("\n\n====whereList====");
      ArrayList<Map<String, Object>> whereList = (ArrayList)res.get("whereList");
      if (whereList != null && !whereList.isEmpty()) {
         for(Map<String, Object> where : whereList) {
            for(Map.Entry<String, Object> item : where.entrySet()) {
               System.out.println((String)item.getKey() + "\t" + item.getValue());
            }
         }
      }

   }
}
