package util.sqlparse.visitor.hivetdh;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropEventStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLLoadIndexIntoCacheStatement;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowIndexesStatement;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import util.sqlparse.visitor.common.bean.StatementType;

public class SQLParser {
   public static StatementType getStatementType(SQLStatement statement) {
      if (statement instanceof SQLSelectStatement) {
         return StatementType.select;
      } else if (statement instanceof SQLUpdateStatement) {
         return StatementType.update;
      } else if (statement instanceof SQLDeleteStatement) {
         return StatementType.delete;
      } else if (statement instanceof SQLInsertStatement) {
         return StatementType.insert;
      } else if (statement instanceof SQLReplaceStatement) {
         return StatementType.replace;
      } else if (statement instanceof SQLMergeStatement) {
         return StatementType.merge;
      } else if (statement instanceof SQLTruncateStatement) {
         return StatementType.truncate;
      } else if (statement instanceof SQLCreateTableStatement) {
         return StatementType.createTable;
      } else if (statement instanceof SQLAlterTableStatement) {
         return StatementType.alterTable;
      } else if (statement instanceof SQLDropTableStatement) {
         return StatementType.dropTable;
      } else if (statement instanceof SQLCreateIndexStatement) {
         return StatementType.createIndex;
      } else if (statement instanceof SQLAlterIndexStatement) {
         return StatementType.alterIndex;
      } else if (statement instanceof SQLDropIndexStatement) {
         return StatementType.dropIndex;
      } else if (statement instanceof SQLCreateViewStatement) {
         return StatementType.createView;
      } else if (statement instanceof SQLAlterViewStatement) {
         return StatementType.alterView;
      } else if (statement instanceof SQLDropViewStatement) {
         return StatementType.dropView;
      } else if (statement instanceof SQLCreateProcedureStatement) {
         return StatementType.createProc;
      } else if (statement instanceof SQLAlterProcedureStatement) {
         return StatementType.alterProc;
      } else if (statement instanceof SQLDropProcedureStatement) {
         return StatementType.dropProc;
      } else if (statement instanceof SQLCreateFunctionStatement) {
         return StatementType.createFunction;
      } else if (statement instanceof SQLAlterFunctionStatement) {
         return StatementType.alterFunction;
      } else if (statement instanceof SQLDropFunctionStatement) {
         return StatementType.dropFunction;
      } else if (statement instanceof SQLCreateTriggerStatement) {
         return StatementType.createTrigger;
      } else if (statement instanceof SQLDropTriggerStatement) {
         return StatementType.dropTrigger;
      } else if (statement instanceof SQLDropEventStatement) {
         return StatementType.dropEvent;
      } else if (statement instanceof SQLRevokeStatement) {
         return StatementType.revoke;
      } else if (statement instanceof SQLGrantStatement) {
         return StatementType.grant;
      } else if (statement instanceof SQLCallStatement) {
         return StatementType.callProc;
      } else if (statement instanceof SQLShowIndexesStatement) {
         return StatementType.showIndex;
      } else {
         return statement instanceof SQLLoadIndexIntoCacheStatement ? StatementType.loadIndexIntoCache : StatementType.other;
      }
   }
}
