package com.chenyang.druid.proxy.jdbc;

import java.util.Calendar;

public final class JdbcParameterImpl implements JdbcParameter {
   private final int sqlType;
   private final Object value;
   private final long length;
   private final Calendar calendar;
   private final int scaleOrLength;

   public JdbcParameterImpl(int sqlType, Object value, long length, Calendar calendar, int scaleOrLength) {
      this.sqlType = sqlType;
      this.value = value;
      this.length = length;
      this.calendar = calendar;
      this.scaleOrLength = scaleOrLength;
   }

   public JdbcParameterImpl(int sqlType, Object value, long length, Calendar calendar) {
      this(sqlType, value, -1L, null, -1);
   }

   public JdbcParameterImpl(int sqlType, Object value) {
      this(sqlType, value, -1L, null);
   }

   public JdbcParameterImpl(int sqlType, Object value, long length) {
      this(sqlType, value, length, null);
   }

   public JdbcParameterImpl(int sqlType, Object value, Calendar calendar) {
      this(sqlType, value, -1L, calendar);
   }

   public int getScaleOrLength() {
      return this.scaleOrLength;
   }

   public Object getValue() {
      return this.value;
   }

   public long getLength() {
      return this.length;
   }

   public Calendar getCalendar() {
      return this.calendar;
   }

   public int getSqlType() {
      return this.sqlType;
   }
}
