package com.chenyang.druid.sql.ast;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.expr.SQLCharExpr;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import com.chenyang.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class SQLArrayDataType extends SQLObjectImpl implements SQLDataType {
   public static final SQLArrayDataType ARRYA_CHAR;
   private DbType dbType;
   private SQLDataType componentType;
   private List<SQLExpr> arguments = new ArrayList();

   public SQLArrayDataType(SQLDataType componentType) {
      this.setComponentType(componentType);
   }

   public SQLArrayDataType(SQLDataType componentType, DbType dbType) {
      this.dbType = dbType;
      this.setComponentType(componentType);
   }

   public String getName() {
      return "ARRAY";
   }

   public long nameHashCode64() {
      return FnvHash.Constants.ARRAY;
   }

   public void setName(String name) {
      throw new UnsupportedOperationException();
   }

   public List<SQLExpr> getArguments() {
      return this.arguments;
   }

   public Boolean getWithTimeZone() {
      return null;
   }

   public void setWithTimeZone(Boolean value) {
      throw new UnsupportedOperationException();
   }

   public boolean isWithLocalTimeZone() {
      return false;
   }

   public void setWithLocalTimeZone(boolean value) {
      throw new UnsupportedOperationException();
   }

   public void setDbType(DbType dbType) {
   }

   public DbType getDbType() {
      return this.dbType;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.componentType);
      }

      visitor.endVisit(this);
   }

   public SQLArrayDataType clone() {
      SQLArrayDataType x = new SQLArrayDataType(this.componentType.clone());
      x.dbType = this.dbType;

      for(SQLExpr arg : this.arguments) {
         SQLExpr item = arg.clone();
         item.setParent(x);
         x.arguments.add(item);
      }

      return x;
   }

   public SQLDataType getComponentType() {
      return this.componentType;
   }

   public void setComponentType(SQLDataType x) {
      if (x != null) {
         x.setParent(this);
      }

      this.componentType = x;
   }

   public int jdbcType() {
      return 2003;
   }

   public boolean isInt() {
      return false;
   }

   public boolean isNumberic() {
      return false;
   }

   public boolean isString() {
      return false;
   }

   public boolean hasKeyLength() {
      return false;
   }

   static {
      ARRYA_CHAR = new SQLArrayDataType(SQLCharExpr.DATA_TYPE);
   }
}
