package com.chenyang.druid.sql.ast;

import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLCurrentTimeExpr extends SQLExprImpl {
   private final Type type;

   public SQLCurrentTimeExpr(Type type) {
      if (type == null) {
         throw new NullPointerException();
      } else {
         this.type = type;
      }
   }

   protected void accept0(SQLASTVisitor v) {
      v.visit(this);
      v.endVisit(this);
   }

   public Type getType() {
      return this.type;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (this.getClass() != o.getClass()) {
         return false;
      } else {
         SQLCurrentTimeExpr that = (SQLCurrentTimeExpr)o;
         return this.type == that.type;
      }
   }

   public int hashCode() {
      return this.type.hashCode();
   }

   public SQLCurrentTimeExpr clone() {
      return new SQLCurrentTimeExpr(this.type);
   }

   public static enum Type {
      CURRENT_TIME("CURRENT_TIME"),
      CURRENT_DATE("CURRENT_DATE"),
      CURDATE("CURDATE"),
      CURTIME("CURTIME"),
      CURRENT_TIMESTAMP("CURRENT_TIMESTAMP"),
      LOCALTIME("LOCALTIME"),
      LOCALTIMESTAMP("LOCALTIMESTAMP"),
      SYSDATE("SYSDATE");

      public final String name;
      public final String name_lower;

      private Type(String name) {
         this.name = name;
         this.name_lower = name.toLowerCase();
      }
   }
}
