package com.chenyang.druid.sql.ast;

import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLPartitionByList extends SQLPartitionBy {
   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
         this.acceptChild(visitor, this.partitionsCount);
         this.acceptChild(visitor, this.getPartitions());
         this.acceptChild(visitor, this.subPartitionBy);
      }

      visitor.endVisit(this);
   }

   public SQLPartitionByList clone() {
      SQLPartitionByList x = new SQLPartitionByList();
      this.cloneTo(x);

      for(SQLExpr column : this.columns) {
         SQLExpr c2 = column.clone();
         c2.setParent(x);
         x.columns.add(c2);
      }

      return x;
   }

   public void cloneTo(SQLPartitionByList x) {
      super.cloneTo(x);
   }
}
