package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public final class SQLAllExpr extends SQLExprImpl {
   public SQLSelect subQuery;

   public SQLAllExpr() {
   }

   public SQLAllExpr(SQLSelect select) {
      this.setSubQuery(select);
   }

   public SQLAllExpr clone() {
      SQLAllExpr x = new SQLAllExpr();
      if (this.subQuery != null) {
         x.setSubQuery(this.subQuery.clone());
      }

      return x;
   }

   public SQLSelect getSubQuery() {
      return this.subQuery;
   }

   public void setSubQuery(SQLSelect subQuery) {
      if (subQuery != null) {
         subQuery.setParent(this);
      }

      this.subQuery = subQuery;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.subQuery != null) {
         this.subQuery.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.subQuery);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.subQuery == null ? 0 : this.subQuery.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLAllExpr other = (SQLAllExpr)obj;
         if (this.subQuery == null) {
            if (other.subQuery != null) {
               return false;
            }
         } else if (!this.subQuery.equals(other.subQuery)) {
            return false;
         }

         return true;
      }
   }
}
