package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.ast.statement.SQLSelectItem;
import com.chenyang.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLAnyExpr extends SQLExprImpl {
   public SQLSelect subQuery;

   public SQLAnyExpr() {
   }

   public SQLAnyExpr(SQLSelect select) {
      this.setSubQuery(select);
   }

   public SQLAnyExpr clone() {
      SQLAnyExpr x = new SQLAnyExpr();
      if (this.subQuery != null) {
         x.setSubQuery(this.subQuery.clone());
      }

      return x;
   }

   public SQLSelect getSubQuery() {
      return this.subQuery;
   }

   public void setSubQuery(SQLSelect x) {
      if (x != null) {
         x.setParent(this);
      }

      this.subQuery = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.subQuery != null) {
         this.subQuery.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.subQuery);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.subQuery == null ? 0 : this.subQuery.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLAnyExpr other = (SQLAnyExpr)obj;
         if (this.subQuery == null) {
            if (other.subQuery != null) {
               return false;
            }
         } else if (!this.subQuery.equals(other.subQuery)) {
            return false;
         }

         return true;
      }
   }

   public SQLDataType computeDataType() {
      if (this.subQuery == null) {
         return null;
      } else {
         SQLSelectQueryBlock queryBlock = this.subQuery.getFirstQueryBlock();
         if (queryBlock == null) {
            return null;
         } else {
            List<SQLSelectItem> selectList = queryBlock.getSelectList();
            return selectList.size() == 1 ? ((SQLSelectItem)selectList.get(0)).computeDataType() : null;
         }
      }
   }
}
