package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLArrayExpr extends SQLExprImpl implements SQLReplaceable {
   private SQLExpr expr;
   private List<SQLExpr> values = new ArrayList();

   public SQLArrayExpr clone() {
      SQLArrayExpr x = new SQLArrayExpr();
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      for(SQLExpr value : this.values) {
         SQLExpr value2 = value.clone();
         value2.setParent(x);
         x.values.add(value2);
      }

      return x;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      this.expr = expr;
   }

   public List<SQLExpr> getValues() {
      return this.values;
   }

   public void setValues(List<SQLExpr> values) {
      this.values = values;
      if (values != null) {
         for(SQLExpr value : values) {
            value.setParent(this);
         }
      }

   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.expr != null) {
            this.expr.accept(visitor);
         }

         if (this.values != null) {
            for(SQLExpr value : this.values) {
               if (value != null) {
                  value.accept(visitor);
               }
            }
         }
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      children.add(this.expr);
      children.addAll(this.values);
      return children;
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
      result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLArrayExpr other = (SQLArrayExpr)obj;
         if (this.expr == null) {
            if (other.expr != null) {
               return false;
            }
         } else if (!this.expr.equals(other.expr)) {
            return false;
         }

         if (this.values == null) {
            if (other.values != null) {
               return false;
            }
         } else if (!this.values.equals(other.values)) {
            return false;
         }

         return true;
      }
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      for(int i = 0; i < this.values.size(); ++i) {
         if (this.values.get(i) == expr) {
            target.setParent(this);
            this.values.set(i, target);
            return true;
         }
      }

      return false;
   }
}
