package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.FastsqlException;
import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLDataTypeImpl;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class SQLBooleanExpr extends SQLExprImpl implements SQLExpr, SQLLiteralExpr, SQLValuableExpr {
   public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("BOOLEAN");
   private boolean value;

   public SQLBooleanExpr() {
   }

   public SQLBooleanExpr(boolean value) {
      this.value = value;
   }

   public boolean getBooleanValue() {
      return this.value;
   }

   public Boolean getValue() {
      return this.value;
   }

   public void setValue(boolean value) {
      this.value = value;
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public void output(Appendable buf) {
      try {
         buf.append(this.value ? "true" : "false");
      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.value ? 1231 : 1237);
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLBooleanExpr other = (SQLBooleanExpr)obj;
         return this.value == other.value;
      }
   }

   public SQLDataType computeDataType() {
      return DATA_TYPE;
   }

   public SQLBooleanExpr clone() {
      return new SQLBooleanExpr(this.value);
   }

   public List getChildren() {
      return Collections.emptyList();
   }

   public static enum Type {
      ON_OFF;
   }
}
