package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLDataTypeImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

public class SQLDecimalExpr extends SQLNumericLiteralExpr implements SQLValuableExpr, Comparable<SQLDecimalExpr> {
   public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("DECIMAL");
   private BigDecimal value;
   private transient String literal;

   public SQLDecimalExpr() {
   }

   public SQLDecimalExpr(BigDecimal value) {
      this.value = value;
   }

   public SQLDecimalExpr(String value) {
      this.value = new BigDecimal(value);
      this.literal = value;
   }

   public String getLiteral() {
      return this.literal;
   }

   public SQLDecimalExpr clone() {
      return new SQLDecimalExpr(this.value);
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }

   public Number getNumber() {
      return this.value;
   }

   public BigDecimal getValue() {
      return this.value;
   }

   public void setValue(BigDecimal value) {
      this.value = value;
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLDecimalExpr other = (SQLDecimalExpr)obj;
         if (this.value == null) {
            if (other.value != null) {
               return false;
            }
         } else if (!this.value.equals(other.value)) {
            return false;
         }

         return true;
      }
   }

   public void setNumber(Number number) {
      if (number == null) {
         this.setValue((BigDecimal)null);
      } else {
         this.setValue((BigDecimal)number);
      }
   }

   public int compareTo(SQLDecimalExpr o) {
      return this.value.compareTo(o.value);
   }
}
