package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLDataTypeImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLFloatExpr extends SQLNumericLiteralExpr implements SQLValuableExpr, Comparable<SQLFloatExpr> {
   public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("FLOAT");
   private float value;

   public SQLFloatExpr() {
   }

   public SQLFloatExpr(String value) {
      this.value = Float.parseFloat(value);
   }

   public SQLFloatExpr(float value) {
      this.value = value;
   }

   public SQLFloatExpr clone() {
      return new SQLFloatExpr(this.value);
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }

   public Float getNumber() {
      return this.value;
   }

   public Float getValue() {
      return this.value;
   }

   public void setValue(float value) {
      this.value = value;
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLFloatExpr that = (SQLFloatExpr)o;
         return Double.compare((double)that.value, (double)this.value) == 0;
      } else {
         return false;
      }
   }

   public int hashCode() {
      long temp = Double.doubleToLongBits((double)this.value);
      return (int)(temp ^ temp >>> 32);
   }

   public void setNumber(Number number) {
      if (number == null) {
         this.setValue(Float.NaN);
      } else {
         this.setValue(number.floatValue());
      }
   }

   public int compareTo(SQLFloatExpr o) {
      return Float.compare(this.value, o.value);
   }
}
