package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLGroupingSetExpr extends SQLExprImpl implements SQLReplaceable {
   private final List<SQLExpr> parameters = new ArrayList();

   public SQLGroupingSetExpr clone() {
      SQLGroupingSetExpr x = new SQLGroupingSetExpr();

      for(SQLExpr p : this.parameters) {
         SQLExpr p2 = p.clone();
         p2.setParent(x);
         x.parameters.add(p2);
      }

      return x;
   }

   public List<SQLExpr> getParameters() {
      return this.parameters;
   }

   public void addParameter(SQLExpr parameter) {
      if (parameter != null) {
         parameter.setParent(this);
      }

      this.parameters.add(parameter);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.parameters);
      }

      visitor.endVisit(this);
   }

   public List getChildren() {
      return this.parameters;
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + this.parameters.hashCode();
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (!(obj instanceof SQLGroupingSetExpr)) {
         return false;
      } else {
         SQLGroupingSetExpr other = (SQLGroupingSetExpr)obj;
         return this.parameters.equals(other.parameters);
      }
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      for(int i = 0; i < this.parameters.size(); ++i) {
         if (this.parameters.get(i) == expr) {
            target.setParent(this);
            this.parameters.set(i, target);
            return true;
         }
      }

      return false;
   }
}
